(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    }
    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    if (!echarts.registerMap) {
        log('ECharts Map is not loaded')
        return;
    }
    echarts.registerMap('西藏', {"type":"FeatureCollection","features":[{"id":"540100","geometry":{"type":"Polygon","coordinates":["@@JIHYMQKCEKBKiWMGCKCOFIGUKDQCGKE]@UEKOES@OCQIUAMN_JSGiWcSAI@KMGOCKMBOJIRAVIEQKMW@WCMGKOWAUIMMAMEKQ@ORYJUCeW]YaWSGQOQEqAiPUNQBKGBQCWMICOLSAOMMBQVMXCpMV@lKVS^YFMLKFKJQBSJSLGP@`TPPBNH\\RFZ@RE|CEII_OcEEICGACEEcBI`iLGDKDSIW@OFM@CGGOKEMBMHOX_AKCKcMMCUASGGBIPGFC@CGGQGGIGICOQOIAI@A@UGIOB]NIIQ]KEQEqLQ@MDSJ[MKKOCSIIOSKIKCAQDS@ILIFKFIBI@KCICQGQDMLI\\M@UDWCKDMFU\\IFQFKISBWHW@KDSCIMIIQBCPMJiJB]OQFIGCMKWEKQJOBKEWSQEUDcDEKAKAMcEcCGZKHWHSBWaUBMFENGRJTFZBRUDQGQ@QBQMOCO@OLOJQAMGOMQSeUWIYGYAQWSEiKOKaeSGSBQF_TMFYCQFQJUZeJMBÃMKNQIOGMGoQOMMaOO]QSAOCOBQK]iMGSNQ@EGH[CMSAUCeYOKaSYIYE[C_AKOGMSI_EUIsC}QG{KWAGHIFMFCDmHOAMAQKQEECIMODUIGCEAAE@KKQKCOAEAI[WEEIIGUAELKDUO]OmCiSI@CFIBCAKEM@MJM@GAIEyUI@IBULCJIJGLWRklED]H_ZyHmT_DMFUHEQNcRU@aCmPWGDgBQ@MKSE@_ISHcE@oJIJ]JCLMPMJiXWBOLMTSHsLOJKLAHF`@PEnSNONATJNrAJDDF@VBBJ@HCDBDPKPYLOJMJKLKPGREHMLMFAHPPHBJ@RTFJXVJRBLHJ@DHD@HBBP@HJALABGFAFBJ@HCHABM@CBEBBDF@`RLDD@HEL@RFRBbPAFELBLPLJPDNLLJDDFENGFG@KFKJO^IHGFW^@HJJBFAPDFJJDHIHCFBFJF@DShETOLABHJDLOPALJVEhBVHXFLLJNHjFJ@JAHCFAF@FDfEhQRQXCVRLAHGRQJCTDPEPIbAXJrTLJHNJhEVARDVPDLCVCVDDlFLh~XZJRAPDVHRNPHLLJRHPBHP@NKTLPfTFTAP@^HpFPNNLHBRHNLLRFT@lHdPXFT@V@RALGPQNKVB\\DJNJ`IlAPFRRJXDVBRHLLANBRFPP@LEHKZCTHJFNLHLXXPFT@LIPEPDLHHNJJjVNLbXLJJPJFTHPBLFGLKJOTM^YhCLKP@HCJINQNADBLFJºƘÖLb\\¨PjFHDJHJTHDNFPTARLPFbXLC\\G`CJCHGjOLIHKFAJEBBDLJLTNNHHFDRTAPKZELEHGNWXMPOJKDM@EAEGG@EHcDAJETADJPDTNFAAEKUMM@C`QmjQPBNLDBPBFFHPAHAFJFTT@HKLYDADH@RLLDJ@jJHFFJLJ@B@DGD]HEFCFAHYFCRBF@BCFSXCRCFLX@JBFjTBQZKHAND\\GLSPGFCB@BFNF`fDTGBCF@DDDDBFENJD@LÊ]IQHQASHODQfUCMA]HQ@^aIXwDUPOPWTGPKJ}HUCSCaIOB_PGVDZAlINKHQB[HMPKhGrCrJ`LhL^NtRFTAZBZFPJ^bVBDKFOFUIgDWFSRQ\\OXIRIrSTIZ_ROhmCIAGbOPU@IDCHCDAL_JKAEKAEE]IUBQEMOMEOC_BKIB]KQEBIDC@WE@QDQPMFGFCBGDBJLHD\\DHABGDC^EDIAGUM@EDWNQDUKSCQ@SDQFMAgHkHUNERBJF\\JjONBPGCMDKI[ZQ`SJWBUCQ@WHKZGTFFL\\TVD~OZVTJPFPL\\ClQRCRGRCDLTPP@JITHFLFT@LBRN\\LTHb^TDL@NFLLH`@VK\\IXMZiRSZGvIPK\\CFLDLJHhKRFTD|OLGWLFNGRFNARINCNFXCPHVD\\@PGhGLGLM"],"encodeOffsets":[[94840,30945]]},"properties":{"cp":[91.132212,29.660361],"name":"拉萨市","childNum":1}},{"id":"540300","geometry":{"type":"Polygon","coordinates":["@@BEFCHAV@FFCDJBDJF@HCD@HELAF@FDD@DGBCJEHBBCDBFAFGBBAHLNBCDCNCDAFBJAD@NIJBHHL@FAF@|K\\\\FAVKXA`BLFP@PFVBHAHGDIDEJATHLAHBHAHGBEAKFKDAJAJBN@DAJBFDHDNEFCPBTABA@IHC\\KZFNCJFdEFETBFEHMDABEDATCFBH@HBF@HAJIV@JMDAF@FEHEN@RDBABGAEHILEDODCZBNMBEXCLBDABAKGBKHGHAJCNBFFB@LOJGJBLHJJF@BECKFENAFG@IXIHARDBCDANARIHOHAJFFADIBGFGPEL@DCEM@EMMAKVLSJMBGECKECC@EFIAMEORKH@J@HADEHEHMDCLCDCRYBGDOBAD@FEDOHEDKDCFKDCFG@KHM@IFQDCNHB@BACQBI\\AFC@AACDGNBHEHEBECEBEZ@DCFIFGHCJEPQpcBECECMBKDEF@TEBEBCTELIBIAEMG@CDAFKACECAG@EDADEAOFKAAOIAE@CD@@EGAAEHEJAJA@GAC@ICGE@GCKIOCOEAIGM@EJGNMDSBCAGDGDCBEBAHAHCCGKGEI@EDCBAAEEEBCDAJBN@FCRBFC@AGKAE@CHKJITEHCDEACGCCE@CHMNAVBFE@CAIDCNCJ@BAXWFGBIAGDADMDAHCDGCMCC@CBAXALCJHDBF@DCBE@ECECE@GDEVOBA@CEAKAAC@CHEHAFEAEGU@GJKLG^SJCDCDCAILKJIBERMJAFCBMDIHARDFABC@C`Q@EJMREZWH@FC@CDCNIHIAE@IBAHCJKLK@EFGJ@HAHGHCTQVGHEJALIDEDCRBRELIDO@C@CF@RKHEDE\\KJALCHGFEDG@GEGBGNKNENINQNSPKBCIMKEGKIEGIEOKCCCSCKKKOWIACACCAEGEKAcEO_[MKACEKGEEBABDFAFEDOAGDGFMBGDCHAFIN@HCNCBGHGFADIDGF@FOTEJKJADGH]DUHC@EGE@EFMBK@MCGGIMCEAIS[@WIYCE@ICGGWBCAMBO@EFODAT@DCFIEcIMKEOCACBEFEVIL@N@V@JIACBE^GNOPCDCLUFGHCDGHCFELEDEJGBCCEAE@EDADKDYAC@EHKTOPEDE@CEIFMlaD@F@L@NEDODCPGJEHAFIBKNMBC@IAQMWEgAEGOUWEWEK@ADCDE@KDGb[ZKVEDIHGnWDCHSDQNCR@LIBIAKFWDAFBHCDEJGJMFCJCT@nQVCDCFEFkDIDMAGAEKEICO@GAEEBKEIGCUAMEKAEI@EBON_FaPWD]@CIKDORONAHGBKCIIMMKEEDKBQLEFEAOEI@EEKBKDGDEDKLKDG@IEIDQj{@C@c@CCC@KF]PQBOAUCCEACCBKAOLS@EGKCMBETOHGC]AGDKAIBGJKBECIGGEKOIAKJIBECI@GDOFEHETODEAOKOI]@GDGLEBE@EGKAEFKLCVAJIHKBEIO@KHIPSHCN[XWCYKY@GJYIQCK@EBCPEBABGAE@M@EFGFCFEGG@E@EBAJgG_BEFGRGHABGEGOCAWGG@C@USQCCI[@ICE@EAEQMAC@SCOEGACII@KJYBOCMGICEG{MU@WCE@CBC@EAKCEAAFGCOBGAIGK@GFG@CGK@EDILABCGIBEBCNKFKFEDOAG@EFMb]HKDMFEFKLEFGAEEG@CFEBGAEI]@KCIJIFQAOCO@KHBBANKDEAKGK@IAEBC@AHEBCBGAEEE@CFKDA@EDC@ICAKCAEFGFkDE@GEE@GBIFWAOFOAMDSFIFMGMIG@GDELENCJCRYBCCI@ILIHMJGLQBG@I@QCEkDCGECMAKKU@aCSAICIIACESCAEBIJGFSDGF]FK@CI@eECQG@AAIBiBMFKBOHCF@DCJ[DCRGHIHQDCJW@KJQHU@SEMEIGCI@QEGEEGEAKA]WGQGKAGCCIAYBMMAEBSAEGOAEFSCKCO@QCGKKHODO@KBANEHCNE`QHBVFLMDEAICGKIFK@CHQ@GCCMCIJG@ECEEO@GBGFE@OODMCQAAIAGGCAGBKCG@GJ[FMBOCIKMCWJADBNEDKFIJBPAHDJ@LADCDMDA@RPAFGJ@P@HBDJDELIFELBhBDFD@BOHEDADBJHV@JQTAJCLIFGH@FIHGDAD@BFBBDAHCDBBCBYBGLCBSCQWECQAIKSEIGAKICACECIAGBOBEFEAMDG@GBC@IHMBABECM@ICGBMABGACMCACBGRCFA@ABIII@CDEJBFAHOFENBFAAEEEKO@CBCL@DAAGGMKEAAAEDK@EBCBGFK@KBKDGHMTMBAGCII@OAAGEAECKBIDKB@JDDA@GCAACDIBMFCHABABIHADCDC@CEOAMBCJADC@CAIDIEC@G@EBACCMUMKMESKWE@@GWGEYGEASDU@@CDMCIBGJKPICMDKFMHEBCDGDCBC@EAGKGHIBKLKBCAAGI@ADGDILKDIEKEC@ADCTGIIAKBEBC@EACKMCOKK@G@GJUFIfCVGPGTBAKHSZiACGG@ClOJIBM@aGKDWRQTCRDRLPNJBDBFADWTEPGDIVEFMHWHIJCFDLAHIHEJGVKJQfCR@JFXETIRKLHLLLDPH\\O\\KFELKVGTUZI@GEQKUIgIUAUCE@ALGJQT_HUCGHEJKPAT@XITEBEHAPFLE^QLMPKFiPcfEJCDGAEEBE@CACGEYWEECGGaIOKBaD[FKAUIGCCLDJBhCLCDSDGDILGTSfgnKT@JBBB@LKD@LT@DEDADBHJHRFHH@DEFEBIJaXBB@DABSLA@GE[GW@EDADGBCFBXCXAFEHDJ@NDHAHMJOFOJQLQRSdENsLKBOKGQ@]QOBgAmGaJadITDZWRIB[XIdWZSH[XGVCPYTY@ILOP[CUTMNGF[GW@[LURSLUIGGOEUDIHYBKEOA@A@GBIFEBI@CCG@AHGLEXCFCDCBIDEPMVURMNADEGECEYQUQAIA@GBML[PC@MEUGIIAKCCCKCCBADG@IMEAAAQEO@GDGNERCLKBGJO@EGMC@OFE@MAKDSQ[@GECIEAI@UA[GwIWCICG@EbEN@NEVANDT@NBDFVL^H\\DVCHMRGLIjGT@RBTC\\BjEBI@kGIBEBCFB\\ABULURAB@DDFLLFLAFMDEDAFFRNDPJPBURORqs\\SNAFBFNHLBDFFF@BYDIDMAQFWAEAEEIEKAGDINEDAFEBIAOBCEECAKQ@AIAA]AqDGF³¦ILCFEbJbGFIFCLGOE@IGWoCOFMNGFEAGKQGA]HaRIBkEICMICEKiBSFQHORGUIGYAGAIMSO@EDc@GHGHCTSJAVAFEB[E]EOIMEIDKLOBSAeE_BKCGOIQCKBMJYTE@e]CGE[B]A]FeAQOGO@UDOFGL@NBNLR@FCB]CODibeDSFSLQ@MMQES@MFE@{OSJIHCJ[jAD_nKtOfEJQJ]JCFMJ]XQBA@AL@PBHAFKDQCM@_XIBiXGL@DPJDFJH^LJHLTDBF@R@RCJ@NPPNNAFBHFD@NK\\IXILAH@LB^RHR@TIRMN@DFL@BABE@MCYJKLY\\SNCJUJYFGBONGNEFFDZ@TBJHJbLJHLBTPRATM\\INQxAJG^GLMJ[TKBI@[FKZAXG^OVULUBMAWBWN]XMLERBV@PS^@XL^VVfJLNB\\TZNXA^NVRXbNVRHPAZUfARJVtVXNTTX^LTJ`@PKP@RXjdnD^UX_HIGDGBCB@BFFTB`RBBDHHH@DAB@JDD@FQxBPFNFF@DAJCHCBKC]B@FFFBDEBQHQPODBJFBDB@HKDMJGHMFOT@LGBQ@KDGDADEBUYAWCECAE@GHSDECEGCCS@AIAACAEAEBKFSTGXGNKLIDFDPDFDAFCDKFCDM@SHEEMAIGOEKDO@CCOEIDgJSDSBUEYGKGOE[@QEKIQIMEO@OBQEKOIyGS@QAUWSUGuJQCOCEQKMU@[FOVGRAjINMBUWOAIHGTOPQDUCUKOOOGSAKEuZO@UC[@SJOTANBPMLmPUJOLONGNBTRN\\JHHCLeVLOLKHS^WHORKbMFMP@RERCNGLSBWNGNMFeFKJFdRTRnGVMRQJcDgB[J{NSASBGLSF_H]\\KHM@WISKQEMFOPQLOHJeCAQFcCMSCeLOHWCAKFOEOMMMGSJGNELcRQNENBPZXLJFJQBeJQRSHWBKLYPOCUIWEQBIK@cKIQAeRINYNQRWRULWL[ESEOMUaESDSGGAKhsEQUENMC[KIOUEQNKDENKLMDMJM@KKWIYEYBOBKNGROHiFaHSPOF[CMCOIKIIESGUC[JSJWDUBUF[\\MFQ@UCOI_UUEkFUCQEK]UC@EDEFMAKN_AAmEMESF[D]@CJMBgMW@WLGLW^UAUECWDOGOQCuB_@YBOLCPBNB`APWJKCMH[FY@UKY[MKWMY@OOO_MKMEYCWIUeKKcDUAMOQKgLgRYFCFC@@DBNHHGDMDW@MDGDKFAPGJSGS@MNKVQV]LSGWEa\\OHQPMIgCeBQFFLENijYVYDWGK@MLBlGJcZgROLGRKRYPMAaFSJGLCTFJNPLLXLBRILSdERBLIRsLSGA[PCRFPJHPDXPPFLJFRN\\JDx@RJRFXSVGTCLFPQLGLCKfATLRDNGTC\\JLG@KFKNC\\ARI`gXaRCXCVEXBFJHHTDNN@\\LTNI`ET@XDTCd@TEIRIjIVInHRJ\\VPBPER@dJV@d_ZClM\\@THHNBVDRLXBRJPHXKLcRKPKZEZAZMNQNOVONMTOAZCTKPWLeFKRNpTvNVHTFXHVZN\\HRHNFHLCTMVCZBXBRHTJXNHAJ@JELBFPANIlMHCPChJHZJN`@RPGNIHDTRBfANGXEXCVBVHVLLTRnJRTDhbLCXLPTNLVJTDRARSHI@OkiEIEKDIRSTM@WFUDKP[PGVAPAXBRATFTF`PNRTNXJhTNPNCNEJIDIHIBIEIWUSGKQDQAUISAKIKKUM]BUEQCBY@WDSNkHMH_LKPGJMJO`WVFVBbUFDFHENFTHDRADDAdBFlIPPNHP@VDPAX@jV@HIRFLTB^ELHVECO@IHATB`PDPCJFDHBJFNHDBDBRKJEBIHSZMNGLAJ@FBHCFFHCLIPCBCJSLCHEDEDBDHFCPKHNZFTEXILOJFPEPGL_XGJKHUFKEIQULSPgXKRST@PHTJRddPLHLFVBTMVGRGdKTOJSD_PWH}JCOBMFGHStAR@H@HNJFFGHG\\GNSDYH[BaU[FERBPCNDNHRJFXFVARDP\\PRR@PAVHJJFPC`GTG`@PE\\GNGLQHoTSF[@[NmNOJINFLCjEVBLFJTFLDNJFVARArEXMLGVHPCD@DK@MLIDTBTN@DDDFFFFBPDFBHHDDHHFDD@JFLCHMDCBIAMJK@CB@BFVB`AFCD[TCFFpANDLALBVNHDD@FEZBLVHHDDHEACBIJ@HHHBTJHHJHB`VNPHDJAFDNFLHJBHHLJDH@NDJENBLFPDLCDDLLPFLBJ@H@HDH@DCBEBCBO@OTcVIPMJEJEDSZIHGL@JJNBHAFINBTAFGFX^DLDTBFBN@HBB@D@FTLbJLHDFBLATILIBZDLALHJPD@DJDDFDETE^BDEAGFEJACK@CJECE@CRMFILBF@NGFID@JBTGTYD@LDHFLDHCTDNDDADMHCBGJMAK@EFGFG@O@CFC@IBELGHCbADCBEFBJLFDHAJGF@HAJDN@BFNLEJF@DAHAFCNCNKJCJAHDFDBELKJCL@HEJAHC@GDCPIFIJENPPHX@HEDAFBDDLBDEXB@DCNDHRCF@JFNDEIAEDMDAVCFBBJHFNBL@DIFCXBJ@FDFFCJHCFBBEACJEAGBIJEBE@GAEBIJFTEHCHGTQGBGCACEAECGDEAEDGCKDEEE@GEEBOCMIE@EA_BYAAAGBA@K@QEQKQBQCIBCAEBKCABI@BECKKIGAHEECEIE@AAAMDC@CCMLINGNIPMPBLJT@DAFLHHJBJDRBJFL@TBHFDFJDFHRBDBHBBD@TLDBBBHANBBH@PIRBJDBYAKJEBKAAGCCG@EDEHCBCJS@IJO@CECFI@CDECIBE@EHEAGFGBO\\GFMI@GCAEAAVWBKJKD@FCJADEHCL@FK@EDG@CF@HFDBTGLHNDNEFKF@HDD@HHCFIVDD@DBDFJHHNDN@LHRMFAFBFFBC^YBKBCXBFCBACI@MBEDG@CCEIS@CBCLAJCJQBMCIBEDECMAOFMDM@AC@GAIEC@MFA@BCCE@CACGAI@AGCAIB@AJEBSFGLKTKLERMACEEOAECG@IAAJGFIBA@EM]DMCCGEACGC@K@GAACBKDACIW_IC@ATOBE@GSEAC@CFCJMHELBFCVFAIDELCTB@CCGAQBOBCTKJM@GEKLQBAAE@@HCAIHCBA@IHG@EFI@CDCF@JEXUBGACGCCC@CDEHERGJ@HDBADGJGJSBAREBIBCLIDWDAXC\\MFAJ@RLFCHEFANLNFBJAJBJBHBBJBJCN@PDHJDFADDHHBRCLBLATCNALEN@PED@JFDBFCLIZC^ITDNARGRCPERCRGFIRSDGBODIJIDSBEHGJGDEFEPIJFLDHLCNJFH@HDFN@FCVIXBDNBHFDVJXFHBHFD@DFDHJFDRVLVBHDH@DFBBABBDAD@DAFDF@@BJBF@FALBD@B@@AHBJ@ACHCLBFAFBFADBBAHDBBHCT@DED@BCFADMGaHUHEH@FGd_RMX[JCL@LDFGDIDIB@JBFCJ@RIHC\\@DCAQFC`CNBHFBEHCNMBGBaFKAMBEBC@EAE@MEMAAHO@WJQHCV@XHVBFADEPELDBF@FHDGJ@DFBBJLDDB@HCHBN@JCH@DBHFDhDFFBLC\\FJ@LFFABELKLCHMLENSTBLBFLLBDABYPUPIBYJUHCD@FJ\\BLARKX@HPVVHJ@HBFRBDHFED@FNJAFEBABDFFD@FEBKBGFCFAHGHAHIN@DNBLBJE\\DPNRHDDHPRFD@JETELA^E¾EL@RLHD`@FCDCVuAaDIPQAcJSDEXMFEFMAGDQ@IFEVOZMPOBEBA`Gp[VEJGFMFEJEZKPMTMFAJAFDDDFJXFRN^NLIJOXULEZIJ@RLCZ@DJDF@`KHEHGLSBCLEHGFIHIXOVGRA\\@N@HBDHDPPXJFNDPEX@FJZTDFBHAPKREDMBIFAHAHKPBLMFEFCRAXCFIHUJCHSJGLA\\ENCd@HDHHFzDLXTX@H@BOL]NEDIRCLCPADIFaHAVCPSXAD@PDLDJ@JADSPMDEDCF@HFFRHLMJIHCZDFAJEDAJ@FDLAHJJDJ@TM`EPMBARERUCIBIHIH@DAHCJIDBDD@FEHG\\AD@NB@JBRANHHBDTFDBBHEVQVELGLAFAFCDGDAD@DFDDH@JDBFBHRP@J@BEHGDQBKFQZAFAF@FDFLHPPLDrF`ANFHBLGHOZO^@NBLEJAR@LHTITKLCLDHFHBRBN@LCRANEPQNGFA@B@PBBTVPVHBJCHCZSD@\\BHDBDFPERSPYNSZBHBDNAHDFFBNDBXGDUFEFKDAPAFOHEDANBRCZFHBL@JCHBF@@FKNENKNBFNXFNHJJJBDABKDQ@IAI@MHODCDABFHAHFNEDGJCN@NELBFFLDNJLDJAL@HNfANFL@FLfATLTFH\\FNLF@TCTEFABC@EGM@GBCFBJFF@DCBEDAJCHCHADBPNTDFHFHDFHBZBFL@LERDFDDLD@BUHIFAFHFDFBFARFJ@HIRBN@BKFBLGFCJARKPKD@FFJAFILM@GBMLI@OEOBGHEH@DLL@LBNDFPJRHBB@JHDHBDBFRDFNLEBQBGDGD@HUDOJGCI@IAE@KHBFDDDD@JCH@HBJR^FBDHTDDAFCAADKHEHCDCFALDNBTRHBBDHDL@ANDLXHHFHAXJHBHIDCJI@CACNAAC@GCGFCAGFCFCFCBIXCDIN@DENGFBDDF@DC"],"encodeOffsets":[[99854,33313]]},"properties":{"cp":[97.178452,31.136875],"name":"昌都市","childNum":1}},{"id":"542200","geometry":{"type":"Polygon","coordinates":["@@N@LMDYB@DAHBH@NCLB\\BAIBGDCJBD@LKL@LHbLTBLID[CYCsJWXWLGCOKKUaOMQYUODOGOCSDcCQU[BQJOBQFOWLF@fNJTJDRCTBPNRJPNRNXLT^VTFP@TA\\MLHLRPRPJXLVFXARENGFQNKBM@ORIVAXAVBNFNLXZRFTDhGZAF^JLNJ\\IVHDLV^LDTIRKzGNIHMPMRIdONINMJQJOAKGMKiXcVSNONMVKVGVAJMBOLIVGJQFiFUNMEKSKKKAMBOGgJQ\\MDQA[Bol]COMIKWKGWGU@[CYFECCWIIGEOAAAAIBQJKBCAQUmE_KQGGOEUKQQUO_YIWAOESGMMGMKCMKOaEi@[EUMIOMOe]qUOO@QESAQKYGYCYQWEaTcI]OQYYaASDYM[UQWMWI]@SCYU_SGMHK@EDKDILGBI@ICUECCKAGDK@CDG@KDSBEBCJBLODABANC@A@GGOSI@ED@HCFMEKFKPBLAFIDK@KIE@I@A@MKIE@IGIIEOAGEEIAKeo@ANW@IAKJaVY^SLIHIFCTIDAFBBABODARFLHBBDL@HJH@HPJCJLLBBALDHB^PVHFHJHHLDRCNGLGLE@EDC\\G^MTCPKLABGFD@ETODBHLFFRGXDtKTDhUZB^CZCZcHGNGDKBWDAL@REPFLGPDJAJANJHAN@FT@JFH@XTV@PJJH@HDJJZFLJXEVKD@JNH@HEBAACCIRSDGHGHQbPNDHAHCHET@LCTA¬OJxAdB|IhZV²D`JpIL[LWNQ\\MdB^JGpQJgBAEEGEAEBGFAPFhEZEF@ZJJBRCJDXDDBhEfNXFZAVKHeVCbRJ`C\\NrdNKRUJ_NM`LH@BC@EGK@CHKBKDELE`@HAFCBEASFO@GNSLIFIDAJ@JEDEHEZEEG@GHGJGBC@CGGAAFG@GDCKOCMBIAAEEACHM@EAKLKFICEOIKMFQCMLQJIBE@CCK@IACBSFOBIJOPMHEDGL@DABEFAHAN@FCLAHCB@DBJBPGHDT@HBZCLEJBBDRBbALA@AACBEPCAIBEAIBCFIJILODGDCFMFCPQLSJEDE@IHCFAF@FDD@HCPANEDCBCAE@EDEBOAGCGFIAOAKAAECI@@CDCBGLK@CCEJKACEACCAC@GACBGDECGDSBEFG@EAIGGKEAAAKGIBIDEJ@FINE@EBIDAH@DANM@MDGHGLEHIFK@KDODGDWFIJETAFCLINGhBJBD@HCFGPG^SBEDQLGDEJUB[HGHS@MJEFK@MEOAOBQACEEBIJKNCLKVGHEBCCGGKOKBCHG@ECAK@ECACBEAIKIGK@IKQAQEU@OFGPGZSF@B@PNDBLCDCJAHE@ICEUCUGOIMGMMKKMESQWMicQIQI[Q_iCK@EJGPOB_JMLETEFOSSmQUQu{KMso{}}aYi[w_aY]iqcgmiYeE]Dm@C{GsWW[OqEMYUQiU·yµcyEOC¯CGÝMOAGIGeKSKmImA]BoH­^PqJwFqEkGyKMYFaJf¥vaJe@©EqEkIY_MyOQgE½CgEKómÙ[[AP¢@bERV\\@fgpCba\\KT@TIPQH[DSLOVK^CZAdBZJHHTInBVJNLJ\\LHJFT@HNX@lLV^``B^JHFELMJAZkO`s°KTYdGHSLKLErGHID]IeGiCS@mLZLQ@IBQ¥eS@WB[HaP{bS`DOLO`KFSDWJENCV[`APJPZT@F[VM^DXNXphznLREJRXDH@XAVPTAZMrKVY^MDM@uMYBWHOH@JRdFPJHTDbEFLZIVOV[PQDWAUMWGADCbUTSAQLMNMBmPEJ@TLf[JOP@ZELQHU@SIEDCLEHIFQB[RMDOHQFYV[@KTQLYAU@ECAKBKFG@IUWM@KGU[EO@GGOWYQK]Ji\\eEOGGKWK[CJUFOAKGKOKOIACFOBKH_@EACGEGGKCKMIOMICGCKIMOAyBTIDcXUVWLi^EFFDH`HRFL@HKHQTOGYGKCIAODKD[AKBQFKJ[L]RM@EDQ\\ILYXILMNCJ@`CJGFEBOGIAoLcPm\\MFULKBQCQUECcOAWAIEIK_WEAONGLWVWHSBZIASKWOQE_BQDMTGFMFuDuGIBGFOpINgZ_fIHGDKAODEHG\\CFEBKUAKC[AMBUD]TKBGFCHHvLZHLBFBLDTDR@LBLFDBDFDFHBD@NBPLHDRJLBJBPMP@FEBDFANFH@DEJDFAHDDs@QBIAUEIGKHSBMDCCEMK@IAA@SZH\\BTGHeMULMTCNF^BVGTB`ERILEPDL`PVNVDNLHP@NMTDTDXIVMXPFATOdIN[XKDMD[EGHDR@RFPRTNHPDLLRJRFDXNLjTLRJBPAF@FDBD@LDFNHBDCHBNGTADGBCFBJFLBFHBDFNLJIFCH@JCBJCNRFLP@HFDHJFRAFM^BNEFOVBPMXANEHIFENCDBJHLALFNBLADEDWFED@J@PLP@TANXXTADBBFBHEF@DNPFLADEHIN@LAHfLLNAFDHPJPJDRARCTcrCVBRJjHNFTNPlFPLJPddFT@THTHLBPITJHTDNFLFNLDPCNFJ@JDJDDHBNKNI^GFClkXQHKJIDIVKJAJ@zVJFHBN@NIN@LFDBJADEJ@jTnD^PVPLCFKVBJHFJXFJ\\FBPBLDLR@LBFFBHDVJPCJNFDRFRLNBPBnGDCNEJEHGXB|LH~RtDVJ`FTJHNLP`B\\DZFZJbTPLfZVDTBDNG\\FHR@TMNH^jRLPAPDTB^RPPNbPNpRNHPHRJLMÄNNAfIVYRIREZDNE`SRETATHbfPLjLTFRXZBZHXJfVRTPNNHRBPIPKP@PDRNRAR@RHVCAQEYISHQFMNEVAXbTAXGLGHYdDdFBNBLFLdCVCRFXTLFPARIFLLXDNJHRE^PAjINIDORAJJJNTDLCX@XGTALJREJEV[NELCXDVCN@J[NKRCRHJDLDJ@JALEJEJKT@RCDBJLTLJPTJPDLL\\NTINCR@rKRFLFR^JJ^MPAHJ@V@BBJPJPRJDJHHHHRDHD@HEJOHATHVBNDdNDLBLW`GPANFNPLHH@DEN@PJXCTCLKH_jAJFdDFHBJDFFPdJ`"],"encodeOffsets":[[94612,30539]]},"properties":{"cp":[91.766529,29.236023],"name":"山南地区","childNum":1}},{"id":"540200","geometry":{"type":"MultiPolygon","coordinates":[["@@ZBfAxGtIjMdM^MRDbDFDD@D@FCHUCA@CHADC@CACEEAAFCPCJEEQ@c@CCAAAI@QFE@ICA@EPGD@PABK@_NCJGPUTQHMLIHOBILMBEGEBI@CCCIGAOACGA[HHWF[HF^BHANCNSlWhafQPOTIVIXEj","@@LBL@LCFCHAJGFCDCNEDEJGBIHALGHBNAXDlENC\\ALBVNH@D@FC´RHEAE@CGKBCFOBAJ@FAFCCCBALBBEFALGJAlSMHCJWFAFE@KAGQEACDCJAAK@GJGKWCC@iHQj_ImOeBUNCPKFC[_EICQBIRGTSVBC@MBALAFIZULGDEBICKBIBE@AKcCEQC@SBCJGJADBJJH@D@HGPIDIDAj_VIVCFEHENMBEAIQM@ADCBEIQKCMBIDAHCBEBSAyWQIIIAMQOKWUGOBMKKQEiSSKEMGEEEF]AG]QOCGECMGEQC@CLOGMMOIMWKIKIQAQBSAYCU@EIC@ADIIIaIE@IEOAME@E@AXGHKCA_@CACCA]BAJ@HERKPANEFCDMDCJEGEUE@ELCAOACUGK@CEICMIAC@CFG@IBCBAXKDCBAWUIEMSUIGO@MHQAKBEheFCBCEEICCCAEDEDCTARFFFDDZAVFPE^OPCHBNHN@RAJCNQBMDI@UDEFGDGPCBC@GEGCEBGPODETO@CIKJQDG@MLOXUBCLMJQHIH@NBFBLCRDFAJ@XGJCDCCOBICOEO@S`WNGPMVc@UEaEMSOPYCOFIDU@SCWHQBOHQESMIGQNKBQEQ`MLGNCZPP@LGDKLMPAN@dBrHLEFQM]@SPEXYTG^AJINKFUbiPMHSPQPC`cTKTG`Y^SPMTIJIFQLGVK\\INFN@LIVcTQVEdORKDKASJQRITBZFPFPJLDV@LFPFTBlK`SRSNKRCNF`PLNT\\NATFXBNDbRFTBPK`SRCL@NDLCNF`VXJRLPJVPFPVRGJMJQ\\eL@NBFCH@DDNBPCD@JLF@JKFETGBYJEBCCE@CBEFCNS@EJJLFFBT@XIVAFBBD@NFLNPADKTKBiRWRaLEhNPCLbLAJdBjLjPXAb@XCfDhL@N@^ATKVS`]VBFZPBLPLVHTLnJlCVBTDRHHPBJCPH@HH@DEF@FNDLNEJIDCDALWCGBA@CPEJ@DDP@PDPAPEJ@PDXANBFHDLBHC@GBETMBADWDCNAP@NINAHGD@LBLLDN@RBDJLOTCHALqÎCDOAGBQPWNKJOFIBEBEFBDA@@VRAzAZNTLJPJbLFZBHLRP@PCV@RBFHDHDCJ@BBBD@FIHCDIPIFGDCPA^K`IDBDJ@RGFMDCDFP@DEHMHKCGBGPQNGLCLAJBXCVBPF`DJCLDPHNALHTAPDD]KpAXEFEFADJNIVADKIE@[NCASGC@IFIBWAOEM@IFKNO@EBCDAJGAEIAA[DCDED@JADYPOCK@EB@PCJEF@FFJHFLPDHHH@D@JDDNJLBxBNGDENKNCNGLT^GJWFY^SRMRMVCHbnVpJCVSNONCHGHCFEJCB@BBJPBDNDbBNDHFDBLEXBJAbBEKCEBGGMJETEH@JFFFLBFBHHFEBELAB@DCB@BJLJJLBFHDDB@FDDBHFDH@BFDBFB@HELALDJ@DENAFBLRXLHHA`KL@FJXT@FANBJ@JVHDDCNQNKPIFCHBBFFNDVCTFHDBXFNd²~`Nm¢mMEG@GDEAOHQHGJOJeB[EQDuPmHOIMD]HILGN@JODMHQT[VAPGFSBWJKh_ISEEMWCKFw@QdsOMKMAMHIXENOHKBM@OGUS_AKDMXY@KU[HILE\\E`@RDNBBZAHADEE_BKdkDC@IBGTSPaJOHGHB`ZVJCBCFEFcDM@EDOfEBODEHKFMN@BbUìcDJ@ZLPFNLHF@vWTA^DRA@DofCHBJ@HCLOFI`IRDR\\TPHPNV@TFTQHiBL\\ANBLVGXWD@FHJDn^JLNDJNPBHINgJC`BPCTQVcJEXEFFC`BJI@NAJGLEjEFAFCBC@UUYM@GCECGeGWBWHGD@DFRHDXFHDNRDHDJ@PCLCZBFPFFAJ@DDHLBN@JFxOEB¿T]iDOAMBSCQ@KBQLQJUHMJSPCD@H@DNBbB\\DD@BLFH@HOVIHAF@FFP@T@FCHSNBFDD@FMXIDSCW\\CHCTILKJGJALBBFDADEHìÄB¨F@BB¼SEME@YJWWKQAEJKAKHGIUQEGAGAKEIagCCCAGBICQIOMKCI@EG@EEIDGTKVOL^B@LAP@^BRFVLVFRNLJNZHHPH\\HRHBDANBLHLANBPLXAPBRHV@^TNRGRNVdDNNLVHR@XCXMNMJaBeAkFcEQIQW_IUCQPcLWXYV_\\YXOLMD³BQDKAMEIKMGOAa@WDEJIRMHGDIDKCIBAZLNNVHLCJGRGNBRSKh@LDdDVGZCNMDGHfJJRHTE^OZEPLPHH@LKJEbPH@DCLSJKNCX@CK@I@CSKEGCIPK\\OHCRALKHGEMCYCO_g^CRALKQUCM@QHSRKR@XFTWNIRHJTRBPCP@XEt]XWPCRBdLPIJKPEXMVCN@dlVFtrNHNSLI|fTHLGT[LGbAR@PEXCZDVJVT\\AvEFMDK\\GPIP@ndTD^@NILICOFSTaHUBM@ODkJSPAVBTCTGPA`KPKPaNa\\IRBvXPENMPCRRTdZZ`Bn@zGTGV@\\IPGBUJSBMTCP@LCRQdINQDKJSBOAMBKEKSOCIBODSOFQPOXIPMTG\\ETJVVFPZVDNJD\\ANBNvX\\BHHJVNNX\\TvTLjDdBEdG\\@XAX@TC\\WRCRDjGJMPDHHAV@RLPP@`UTDXFPI^STQLIPFHVBTJPTFRBPDNRFRPVjATKV@TBnEPB\\AF^``L@TPRCTMPZdVTJRBLQDSAMROTGLORGNANDdHZAbX`EP[XOJKJMZORGRCn@ZbJTRDLHxA\\EVGZFNEVCjYJMJURETFVPFVFDXG\\cPI\\EhMZD`XVL`EAeFQT_JGGOJKlD^HNFLRTPPIR[RKVGJYJKPMAWIOIICMFU@QFON[TIXIdGNKFOASD_HYJQLOHCECE@EBGDIBI@iEMGKIEKGWAUFgIUBKPOCKGKRKFSTg@CIEAEDEHEBCCEIICEBOAEII@GX]HEJGP]LILEH@HEFMCEICKKCMIOOKAKFKBEaOQAQEK@GFC@KC_QE@ACFADAN@BADG@GAIBEHEBABKGIO@AA@GGC@CGIAKIQWUEIQSI@GAOOBGNENKFGHQLOLKNIPIZKLOCOCAGDI@AA@UCEICqBIMBSPMTMFm@OE_BGLKPItKTGNSPKXAjWNINODK^IJIpI@dFTG`J@TFNLR@hACXHnObDV@dQRMFVGNE`CnS`EVAHCE@EECI@IEIDMCOMKKEMESCIGJSAOGKGS@SESccIOOKkEMOESGMIiAQDUdqDSBQCQOIOICGBEKMeKBG@KJMFGBCEKMO@CFEAGAECASBWWBM@SKO@O@IFCXEFCBCAKEMBKGKAIDCFMJEFGBMNWAOPUFEAMN]BEEQGIEC@GKOQEDMAIIDG@EDIJMKCEGAAEEKAIDEHABCHSAMDGACMGCE@KACECE@OBIAKQiSMKCWQEQIKKOCMGQSEO@QCQHG\\FNCLC\\WJMPcBSOENWJUCWCSNS@MGOMKUCUM_OCKFOJKFQA_HSAUE]DMNSVKfNHGASG[TYB@JBL@FNDDNCTALGJHVFJBRAt@CCBGCEFI@CEGBMCEFA@ENOAOAIIKCQKGAO@MACEGECACECAK@KCQCSAKAEGKGMG_CaALEHURMHSDcB]@AC@_AIQ]UWEAGDMPIFUDSEOGGGKOEASBGDIPO`GHWL[XWJWCgBMGBMLOXclOJe@SHKNKHUAQJO@IGAGBI@E]GAEDGLCFEBGMWMKKC_EKA_]EAK@yPI@KDIIGKCAw@IGCMMMSQSQQGIMCIGQUQaICOASDOAECGIECIKESqoOM@ETSDMCE_KEMAS[wQ[mqGKScIIKQMOMMICeGOEMMIC]BSCKEMWMGQMS_OIUGKIIMOYCYAQDUBMFMCKMEU@KIGYIMGKKY@KIIaS]MOQAIGEICCU@W@Ah]HWVQS[SSUMQG_EGECOBqOUAiZQLQL[DAVDDAFGBG^URQDK@ODOb[BGkcIsGWeGYGoIIAOFeCQIMUKeIkOYCaUE@QP]bINGTKPIFaP[HFTDlNZBNGDeDUTMPCLIPONAVAJIFM@OMKAGDQZEXE@O@IBCDB^CFQFCD@L@NU\\ERBXDRLD@BEFALBPPfAPCDUBEFCVIZEJ@HFF\\@JDDHBNFHXTHTB^CVHRLJRDRHXhANAJ@FDPCR@R`ZJR@VSRC`F`B\\AVBHh^Lh@PKTDRCbOTK`GNKDYCE@@FDLBpAhARB^CTOL]JQBKHUbQNILGF[\\IDOBoG_F[BMCQCMBEVOPMHIJGLCPEFIAIE]aSIAIBMFG@EAGWK}@OAKGAaDKD_RODM@UGOGEKC[IGuISEKESUCOSGI@eLYHY@GEMCIGKEWE]OW@MIKE[OaQGVMVALQCGGIGUNQeCESByTQHO@ICKQB[USMIAEV]Lc@IIAOKYMWDGVIPKHMBQEOAq`MCWIoQOCI@SHYVYLQFaFO@kC]@SDQL@NHVGJIFOH[DGCGEAGDK@ICGmg]WIEACC[BQEKMKGCISEIOEIEIOG]KEGEI@YFUBgAQCED@HBTDPAJKBO@cEECCMIKIGYCMDMFEJ@VIdGLILMFKBSAMMIKQQG@CQCOEUMYMG@QDO@iFYJBDHF\\DLCDBDBDLCFGFCNEBE@AFCEQGIII@MEC@QIMIYUMCKDMEM@QBUHi\\MFSD]@MASIQOQ_GEWBcF_@QBYLWPIBYBKBIFGFGRCHAXELCFEFOLS^I\\GNGD_LMRUTIFmHUCm@NGDAHB\\CNGH_D]HUJ]hKLSB]MYGMDKHUD_@ULWFQHMP@JLTFLDFNH@B[LGHAF@JAFQHeLUDS@UAwOAECMGKOMQGc@MDEDIRCPGXCD_F]@EMAyE[GMUCSAGGAI@WCKU]MMDWBIFKBICQGKGCaEcIGGCGCSY_KESCqCKDahOLKHQFSCM@MDMJAdEFEMMSMCKBIHSdWP[ByO]LKVGVDfAbGTQfEPCRDPNLVDANILORQdCLC`ETGHKDMGEEBWCOaSWUKMQcEUHGG@MDOJ]CcIkBOJOPKLODIBMJ_DURQLIDG@GCE@CAAI@cGUG]C@EDQCWFG@QNSEI@GFGBSJEFKFCFIFIDMHGBEDHNFPDDDPBHFDFJDDDDLJFH@FCF@DEHIAWJ[^CN@PH`@VGNQNQFKLGRIdOVCNEXGJWJoNoNYN[VW^OfG`EXGITCZA\\MlGPGBYEW@IEA]EK[ASAMSw[a[QSKOAGF@`DtEFyJSDYLGFKFCDULMDMBEBIBYCG@EDS@[FSAW@EAIGQAGCE@CGBMAGCGMMMGAGIKEACESMCJIFS@QBEBCFBH@NABUBYGGK]EYAWEU@K\\YAGHEVEJMFEBEDEBIHMHGHGLECWO[K[@YByPOJGPBNT^JVUhCPEjAPAREP@XFNFJPLPFdBXTLhB\\HFRHPNFJD`Ox@HBJNNFLBR@NIPKLIHcAMFW`ORSPOHU@iUOBSJKBMCmmUOmsKMEQAMGKKGiIMBOH[FYB[CUAeQ_SIAÝMDYAM@y\\gNMHCPJXB\\EJgNUDKPYvSTYLQD}DUFYHQLWGiAU@MDMGKMG@ODebMPYJELF\\ETMNERHTCJ[F_BADDLHJFJ@FGLkNODeCODMHK@SOOF_PWFQJMPILMHWC[IOBOPER@jHpP\\PfDTBPHdC\\KRMNWF{IGDCRFrBJFFXEHYDKFMHEFEfKb@XDRDJLJjVHNDVAXDYEU@UBMNKRBNFR@PIPWLSDWIOGGBYTM@uQO@MFQBGHAHBFLVCD_TMDWAICUSEAiTWDKAQI{Um[MAOLUCIEEGgeDGFCFSKMYEcEU@WDU@SAOGEEIC]YIMIIKG[OCKEGC[IQOIQ@IDMHINIBkCWHMRBX@JIDG@OGMAMBWNW\\DTARMXQNSLKJ@JEJOBOCKDMJSXCLILBXDJBNGXIN[LIHEXPjGfQRKBaESFW\\GP_hENBdQT_NSIMCCAOB]HQLCPATENKNCNBJbHDFMRQLiNWBOJQbOFSDICIIUOM@IDEHHXEHKJUFgHMAYQOE[KKBUXaRKLITEHGHODOREJEDI@aCSCUGMAQDMJCNBRCpCHYGMUQQCM@BGFIXBTEFEDkL_DKDGFGbENKRQHQ@SAwIODEH@JFJNR`TLD^TBHEPIPulODOAcOaMYCeFCHBFDFPBDFRZBPQPiJKJUrabYbOXOFcDQCMGSMKAKBEFGDGHYd{RQFKHen}XI@GOCCG@GDUVQZKJIBmSOHKJINSLoRKHMDKAQIOASBw@QDGN@N^lBLMZHP^NLPDNGJQFM@CBBvEBMBSAgPMJLADBLTXTFLbZRLJHZPFHDBJPNBJFNLNHHPDFFHJHFLLJAFGFAD@NHFBHDFEVALDFHBFDDPJJBH@BGDEHAFBJCD@DEFALN@DCH@LEF@FBnzDFAF@BD@HCFOV@HAHCLOFK@IDApETDVLJDJ@G[@AJGCGIG@GFCDEBI@MTEBGB@BDCRFVFH@FJ@LCJILCDCH@JLFBLJHR@BGB@D@VADBJCFGD@B@JDBJCJILC@EAG@EFALFH@RCNElIPEFEJKVGJOTGDEHUBALABCRAJDPAFFDHFDFBPCVDBBAP@DFDN@AJGFADGDCNL@BBDDLFVAHB@THT[fO\\ONIREF@BBZ]xAJIN@FDFJJLXRPBD@REH@DFLNJLFDPRVBDAFU\\MFERDTHTF@@DPFDDBHCJAFFRCJEHCL@HHNAHIFCH@HQBCFFFHP@LDD^JLAJBPFFBABMJ@FBBVBNHFAJFLLD@HH@BIHADBHFLDDXIJABAAI@CVKPDPLJ@JHZJFEV]dULQ@GIMFG@EHIFMBKAKBaFGJE^CXBbCLIFQXUDELGbIIJG@MIGMGUMKQFQE]DSHOL_P[HGPAPBLBTH\\JVBLALMHcLKLGR@XQTCNDJP`lHXHLRLHNBPXJCJBJ@JDLHDBDNHRD@LDPNVJTDLDZJXDNJPHNBL@JCJIDUVArDZI|KVIJ_@SAYDcVYCUG[ASBMHOJU\\B\\GPSHUBMHKJFLBVKLGFaHELGLAXCHGNKLUAQG_OOQE@MNEJKHUVGPIZWVULELEJINaXGHILBNAP@FKREVBJDZLTBH@NDPBDBHHJHZLPABBHDFDP@JtP\\BLCJDRA`ETHXTJNDBJ@PELBFHH@JCDEHCHCF@DFCTCFKLCLFJTVLHBHCHEBKBCB@DJT@HBF^LLHQNMxJCXOTIlELKLQnALFvH\\LZPP@LCFc^sNgHQFWRQZMLKHCCUEI@MDEBENAHGJCJCLCRCJBHHAHELBLFDL@JBH`]NEF@NDL@^KJEpH`DLFN@dMLAFBPJAHUH]JST@^BPEFG@KGIEIIICGD@JNTGDUABJhPTBHBFDNBRFH@JEVMDC`FHDHAXQNEEKKGEGDCZBNALEFER@FLEFORBHFJLJXLHBLHLDTKFBnTLZJHNHLLrLRDNAHCL@NILYFGFONSTCjHP@LDD@B@FfKfMPBDJABBAFFFBDFBFFfB@LYH]FG\\Mj_XKAQM[JALYBKFCPCPIPYDCPAX@PA^QjGZAHBHJLDLATIZChIHnBhCVI\\SH@HBTLhLXPNAV@FA`QRKHKFC^GN@FDXHp\\HAHINKNCNHJLRNHDLBhCnId@NB^PNDN@`EVBXTJRNLRDPFNLX^V@P@ZSIE@CBAVAF@B@@GJGXEJBFCFIDAPJFBBDBFJAdDHFHJHBBDCJARER@BLFB@@HHLLFHCNANEVBRHNJFBF@JKN@NCB@DKFAH@LFJBDBHADCFAVBFFH@FAFIJY@IDGDiBEBADANFPCPBDHBLDPVVNDHCJBF@ZEHQTYFCF@THBFADSNEHAFBJHLAPJ^AFGJCLENOPMJ@LGJBHCLAJITIEAB@HBF@DIPCJALDVAJZ\\LFHLPHJCPBJCJEPEFEJAFKPKNCLGDABGAGCEBGFOZYJOAOMG@YHGPIZEX@jCl@TGFKNAf@JBR@RChQJ@NDPMfSLMVGCKCAUHM@GAIGEA]BGE@EHE@EACICAOEAI@GE@ADEDKBMqaWSS[IMGU@CHEDEEK@SYMGESUAKGGkOuPWTc@EB[@IDG@ACCGSMC@ML[@GAMGCKBIKMCKWMYACA@M§KCMQ]AAWCWKSCGCWAGCKBWJCKHACBCZKHAP@DEH@TFLEJ@FEHCHBFDFAHILCDC"]],"encodeOffsets":[[[87819,31695],[86313,32100]]]},"properties":{"cp":[88.885148,29.267519],"name":"日喀则市","childNum":2}},{"id":"542400","geometry":{"type":"MultiPolygon","coordinates":[["@@cEMAWGCSEUDMCGGDGJELORMDMCCUG@IAIBMAGUQEIK@_LGBKGQWAKBEFM@CCIBKFK@GEACAAEG@ECAGCC@ECAGCAEIKKIAIA@CDA@KBAFEFGGEAKAEEIEG@SFIFHNAHDFFLaAIBWAKFCAGEMCaAMCACIOAAA@IDEFGDGHMDMPUTIDL`\\GXEG\\GHBBDBPJHDD@DAJHFAFKNAJGPKJGNSROVIHMD`L@BA@OHCFOB@JDF@REJ@BBDB@D@dFRIFODEDBBFFBD@DCDGB@DDBGVEDC@C@ECaCQC]NcNiNsJwHeBYA@THdJbDTBHFDFFRNPDBBBFZJNFPCDFDLH@VCHBFLCH@LDLFHDJHAPCJAHFH@HDTFXEFDNLD@\\@BCJAFED@PHD@HCD@JFBAHEFCT@JG`@LCfEJBJ@P@HCJIJCD@FDJAPRDBRCPGNAFCDODIBYV","@@MDAFAHKLA@SEeJMHIDGNKFEF]NIFAPCHRP@FMJGBO@KFELQJGH@JAHDN@FADFBH@FDBBAFBDBBBAB@@FLH@DDJ@DFFAHI@ADBBJDBBBHEJPP@H@DNJH@DDL@BFJBBB@DCAABHFCDFF@DBF@DDHAFBHADBLABBJBBBJBDJNJF@HDLJHHAJFF@HDN@BDCD@DBB@DDJJNNDXBBBBHCHBJ@HGHKBCDAJCBEF@NCHBDJLBDADELAFBBJABDB@CJ@HAF@FAJDFCFDFAHDBHDHAHDhDDFFBZ@FBN@B@@JFFXFFDFHTDBD@P@BJCVBhGZBTAjFVRJPHLPVHFHDLBRAhDzZNCJGbOZEJBLEPFP^HJJDdDPCPGAfHVBtJ@BADHFALBDF@DBD@L@FED@R@NHLEH@NL@BEDFH@HBFB@JCJBFAHBJHDJ@JFPVPZDdDHAFCDFF@PA`CJCD@HCF@VDDDRBDFJDTBDCCEHEAE@CPIBOFADAJAFK@EJAN@DDF@HDNBJ@JCN@JRBFNPJDNF`B\\RXTRAZKVE\\ARCJBJFPBLHXLLCPALIRGR@XCRBJARHFPEPHR`PHLZTVFnDNBRC`BTBVFJ@RB\\JPHTR\\TLFJHEJADJDPDBBJNBDCLBBB@P@\\MHALFXDVLNFF@FGDKFCPAZ@DAFEGkL_PeRChBZCNBjM`EP@R@`NTDpRT@VFTBlHZFXBbP^FJFLANCTCHCN@BEDAHBT@dFDDFH@NHAPKD@FBFDDHBBFCBIPAPBRJPDN@FAHCD@bBPDbDPHDFHFVGD@FBTPTjPNNDJGfE|FP@TA\\BtBMRAtPLJbZNBbKd@HLLTRJPDXBRAZ@TGOLFF@DBLGnABBBHEJCJEDE@@FLFHCXJT@PG^KNBRFZFbB^BPO@QJIXSHILAPBPDzJPHbJPEPGRKLMNEJIFKD[@UDSDIzSNGPEPBPCPGNKPENILQACFMVMIK@IRIH@VGDAAAFMPILGTAN@JHFLFF@FDDGNBNHFLXNBVLN@DDTP`@VILAVFnVnFLIb}`UVATGRATBTB^KHDD@ZOJGDKDAJBF@RMXCbCFECC@EJKFKLGLAFEFABINHHBFDJ@TDPJdCLEDCLJD@DArxRPJAfgJEXSJAGGAC`gRMD@N@XHLHT@F@LEXGP@^CNMXMZKTKRIXQXUnWTSRKPC^K°QfKPADGLKHCJAHEBC^CNBBABCJADEJGNAPLFEBGHADBD@DGFAJBNL`ABEDAAECAG@GBKBK@KKSKCCMGC@EGMAMCCBECFEAKIMQEMFEEGKM@GEMCMBQAID]EWMIDG@OCK@[EI@GFM@KCKBIIMAIDONWEIHM@IJAJADI@MFGCIMIUEK@GDE^ONMFCHIAAIAAGACBUAMFKFCDM@CAGCGEGKECEBSFGJEjKdQJAXDJBXGPKnMTIJAH@HCDC@CACQ@IDCAO@CEBADATCFADEFMJBFHPCXDVKLAPDHHB@TCP@RIV@RIJATFNBVCZ@TAhHDBDFFBPBDEJCbHRFJBZGDGLEFEEKYQEIACDIAICQCCQGEEHQFOLGDE@ICKACEAIAEBIHIISEEGBEHUBE@KEKOOAEBEFCLBBABACKOEBCNOCG@CBWAUCEECSAKCCEACDELGLOBGFSFGNEJORMAUACKGMEMAM@]HG@KAAAEIC[CKEOCAAE@OHBFGCK@EBIJKKKBCJAN@FIPHPAFDFBLGLWHERG@CEAeCCE@GAEGCGBG@CCHGMUCCSGAICEWE@AFKCCICKQECCFMFSDOFE@KEOAOC_Me]AICEUMOAUDKKKASCMGKEcHS@CAOQ@C@GDEDAREDCDIACBEDKCGMKKSCOIMBIDEFERED@^DJAFC@C@ECCUKKIOCQGYGMKMK[KMOCKBAVIPILKJUBIHMPSXUHWHKBI@GBCJEREJCJCBABIBAP@PARDNAHCH@HC@GRGBIMK@CDCHEDGAYEaOACCACDEHCFICYCMEGSGECAC@ERSAEBIEWM]@EFKBKEEGCAGEEBE@IJMDMBAHEPAHGAMIMBAF@VBb@PCNA@EGKBC^DJAFFJBDCHABHFBXABD@LDBVJNBPJFFHRDBDBD@FAHGJCDAHCFGDAJFF@DAFGRJPLHDP@RJH@RELALGLODAJA@CGGAGDGDEHI@EOECCCGFCJBLAFCZCFIDEAMLW@YBG^GDC@GCCIAG@MGS@_QDKDEAIIIMECEMEAA@CFGEMDKICIGC@QFSBQDGEEM]AAA@EAAO@KCIODGNKCAKCGICEBEDCPGFI@EBG@ECGAICCAAKI@EDALAHCHSHGRCXARGDBBHDBHBDCDOLGLAGQEODM@ECAK@EAAEIC@ABODE@CEI@C^QXSTKBCACCEAEBCLIAAIE@CBCLI@EAGEE@GEEAEDGAC@AHGDI@EACQKBCLEBA@MBCJEDCGMDKEUDK@GCEIEGEACAMQQ@EFCNG^EAG@KCKLKFAXK`HFADEBCAUB@J@FABABCAGEOGIMGEIECMKKCMGECEEAC@IFKAGLMJO@E@CGEIkOU@CHC@CCIDEAIDIMDGAAICGOGDERKDCBGCICCMESMIIGCGAUF]@K[@GDCBOACEAEDGFEBk@SHKGIBOEACAKEECEKMMGOAEGI@E@@IBKAAE@CCBODE@QFKEEECIAG@MC@ABMFCR@BAFE@C@MBEJIN@DCBAAGBALKJSNKACEC@EJMFMAUHCV@FAFANKFEPaFGFIDAXK^GFBB@BCBECOBGLILEFAFCBAAIJGPQJCPDPEH@D@LHNDF@TE`YCIBIBCNADE@MBCXINAHCJ[pFTGRIOGEKEEIMGQQOEAIEAEJOCIBEHEH@TFbCTG\\IRAPEHCBIACEEDOAKH@LCNKFBJGDGKGCGEEAGGG@ABCFABGFCBE@EEEAIMEI_BMCGAIFMDABEACBECYF@LIHIBINWHIXKbEJ@HCBCDCZGR@PEDKBM@IDW@KNKGU@GFILITGpKvOzKHCDCHCb@PDFAHCFGVEFCFCZgJIªÉPWTSxqDMDAFFB@TGJ@JAJEBILCHCBGBAÚLHBFAFAFIDCLKdQrIbOHE@CBCAELCFGHCD@PEBBJGHALIJKDA@AVMBCHANQ`IPIJIJE`KRKLCFGFEHA`FNAHAJDHFP@XIHAHGHGREFEPAPKLANDL@FBFCNABBJ@BAFADCDA\\NJAFDDBZ@HBBA@CDEFKBWH@DGDCHOPbDTZRNDL@NGRAJFJBJ@H@\\BJAFCJ@HCDHBBHBH@LMLCPKFKFCPFHFNHJDBDPBJCj_PG^M`U\\EDBAFCFBD@DDJABFFNJFD@D@LBFXJJCBEBAPCHJJHCPBFHBHDJ@JCFBPL@DCFBBFDJBF@NBNAJ@FCNBFEFKNGJDNAFEPSFAFGRG^BLEP@XGT@XCZKJK@CHATI\\BNADCDGBGLIF@BFHB^HAFAFHLBJ@DRBHDRRFDLDNBFALOHAD@JHD@HIDADBHDH@BCNGFMDALCDAFGBGKK@KBGBAL@BABA@MHCRCFEBGFClGTIT@FGVGNKTETB@GDGCKNCXORAL@JEN@LETBBABMFGJCJALALBB@FEDIBADAHBD@RMLONEVAB@BNNDJHB@PELINFJ@BCBIHIFIFULCDCBABUACAC@@J@VHJ@TAPDDGFKBEEGEACGBCDBDCLSFCFDJBLGDEHWPKL[NAFEACBCDEBCDEDANDF@HCJBDBBHBBBAXADPDDDBhKJ@JJ@DCR@HBDZVLAJGH@NFHBR@\\EXDFBLFHFLTPDXLNBDBFCFKDIFAR@TEPAHAVBLADCAKBGNEVQNEBAGQDM@CCCUAIIICMKMGBA\\QFEBCAMEGAK@KEMIIHENENWHED@VJDADADGHCFENGFEF@LDLANPHBB@LCF@BBBPBJLFDHHBVBXCFCLQDAJBNFFBJN@JCP@DNERALCVKdEJCJBBFDBbRT@NFHBHABCHKJGXGJGDAPDLGHFD@NELAJMPDN@HBJAFGFA\\BFBBLFDF@VGF@JLFDBABG@CBEHGHEF@THJBFE@KHEDA\\BHDHFXPLPDNNRBLBDHBNALGROP@HGXBD@DABIJEJDDAB@BBFAFIPKLGHGJBJEFCBBJJLFRDZAJEXSLELCHCXYFAP@AJBLDFD@LETLFA`ODBBLNAJ@BD@HFFD@JBRKTFJEDBHDFDVFDDAJBBPJHHHDHAFDB@FENADEDWDC@GDMEODAJAFCXCDA@CKYAIBCNE@CCIDUDANCAIBADCBQDGHEHANBLFFJFDf@LBBDDJDDPCNEHBRAPFN@BFBHDFBTVLD@HCTGHBLITIJBNCL@HDNJH@VMAEEI@CJIFSHGREH@VBDA@CBCJALBJCBCEG@EFCJAHCBI@QCIGIBGFANBhKBCBCXKJKPKHINKBOLIFABBDLHF@JBBRFL@DBDRADBFTCLDRALFDDD@LCLAJEBA@IBONQHGB[BWHGHCLBVHHOJOFQFEJA@ABADBL@FBALFLB@HD`EBBFFJFBB@DAD@FLAFD@HBDLCPFFFdNBBBHT@FTJHFL@DINBBLAL@FDJPHH@HBDDDbFFCDGHCLFRDNFXBVBF@JEN@NCDCFKBCD@NJJBPMTIHAJ@FDD@FANCbMHGBMDEDI@ECKTMPALEAEDKAKDEFCDADGISBCHCGE@EFCFDHLFDPANCTDJAPMLED@@LLHTJRBTHXFFEHEFKFCBODEHAZHJ@BEBIJEPMVDJAFBDBBFEJ@FPAFBJJHJDBD@PALBJIRAV@DCLUFGRGVCJEVILDJJJZBDFARBRCND@F@LNLGDMVBHHZZVDLTEZCZAF@LJHDL@JCDEDAREVA\\IBDAJBTrZHIB@HHDBDCFCLHJBLBFA@GFEBIJALDHF@NBFNFFJBPEJENBHFDLT@JPXCTD@HGLAFKBI@CAEDCJ@LIHGJCJOF@XJL@NFDD@NDFAJ@LADCBCFDDBHVHH@DCBABGFC@EDCFHF@FEBDDHFBFBL@BADGAADCT@JDP@FBPLBDBBJDLTJLFFVD\\ALB@BCJGHBFBDPL@ZHJLJBBFATSROJSPM^UPGTKFCPABABCGIACBCNALGHANBHHFBFADCBMDCRCHE@CCG@EDABGLGBCCE@EDALEVET@BAGEG@EACCECCMDE@EBGB@CEIC@COCGIBKCKAYKJSJKBEAGCIKKaESC@A@GAM@EASAKC]CWHEBEASJMBEAGIM@IHKJGTYFCFINIJOdUPSP@DAFADA@CCG@G@GAIEKKOCKDCCKEOAKFMCI@MCGKIGGIAKGMEECIBGCMO_UGAGIIGASGG@GJIDAFBCGGCUGAKFY@ECCMGAUBKCKBMEoDE\\SDCBEA_EU@ADAL@NIJBDANCDGEK@ICCGECGGCAGCEAOEEEECC@CSMSAJCNKL@@CDCGOHUNKFWBqBQEUMIKCSEEIAKFUDiEKJMPInM\\M\\@TEpSRGHKHMF[@OH_HSD_EOIIUGOBQ@OQO[QCUBWEIEGQCMDMAOFQ\\EbV\\AZGTCHMH[HGEEMI@G@GBQTsHGNEPAD~IXG`OTCPILSHcHQNUASEUGKOKccIQGS@OTSLQhWTOVKJRLFVELGHI`WHKFOEOPIJKFWESMYLGDOGEACFCFCDGTKDIDAJODKEGDEAG@EBIHKNMTYJGFALIAQACGCEMCOAAIEODOC_SAGB@JDPUFKG]FSAEKJQ@GiUW@OBUCO@MGOOkJAEBcCCQBGCESFMEGECaVUAUE_XIPINOHKLG`GNMlCT@XAZDFRAVN^LVJLBLJTBVCRLRTHXVFJAJGJCJIJMFMDMOgSWISMMQ_OSESEQBWAOBUBOHO\\CLEV@XSNQTCJFLFJlj@PGJQTQBSCUIMKOSWKKDgaSCIQQmKSUKUGUAWDWFMHeBQACSJGHMQO_@IMGYgIODGDkNMJOBAEFK@IBIMGIWGSAQAWDYNUDSGKMEQG[GYMGUEWGSMUSuMoLQfEXKLODSBYPNSPMPURMNMBYFYLYLOdQLKGWIOAQKWCQAUGMSG[@kNYDc`U@cIQ@OFOA[UQImGUJiJQJJSFc@SDWCS@_FMJKS@[MMSCGGEIWAUFWDQDWb_hQJ[BMDEL@LKH[ISDMHQCSKeBLKDKHORKESDUHWTQEQIw@ICM[EQKIOEWOOCIGEODQ\\OBTHtKJQAKFQTcJKAQWKKKSYDSHKTIbENBZOLQHQPKhQdYHIAkNKL@XHZCZUjiFMEKREfAhDNJROPGb[XFTH^KRULUNMT@THHIBOLEHCNCX@NCHCGGAM@CD@DEZEhQhKEMWIQIoOMMFSJSFYAoEUQMSEU@]A[WQAQFMACYKSGQCSFiOKKEQ@YFW@SA£fOPmNgCEQ@SIMGKWA_JWFUE[MCOKKQG_FULQNc@[IqEMCWJEPIPQ@SGIIAIKGOCqAUHUAUFUVQFW@QCcP]JcDUFaNURSHSRE\\AZFNXFLHHRBVKXQLWN[VSRQTWRqBSC[@[TWTWP]JYMA[EMQGOEMKEQOGQEIIUGSQMOe_SDQL]rGXSJONDJBRENUT[JaDaJWRERAVFdCNBNJNDLKTYJSBMFM@GKQQSJQNkLaX]BMCMKEIBwCSESAOMQMAGNQ@]FQCkSeCQQGOSiMG@OBMLCb[JOFQQeDKO[UAKOEOMOGYIKJmBQMG[JSDUJSAGMNMPKFUISSAMHO@SKYDiZ[BOKDSJSAUEKAQDY@cMMYLKNKHgHOH[@UCOGWDMEMDQJMBQEMHKEXKH{PSCQEgLIGCKEK[DOLuJYHQTYjWN[JUL_@KGEK@MCK]SGaKSM[AQ@KESEKSGIJO@SOCKQDQHQDkR[DOKOESIYU}PUC[SEKSEYHGL@XDRAVIX_TYRJ\\CLDNOHMAiP[IIEQAMFGVGlBhENCR@TDRLTCVMRCX@FVNBHCJ]FCDAHGB[CGCIKCAAHEDEHONCR@RXFD@JCFALRA^LJ`APDNFNPRFVA^JFFLBBFILK`CBGDCD@JGLGJaPBHDJgnQPY`SJqTQJWJ[PQRETCXJhEVEPCLUA]aOIYEYASBQEs]MgK_KqIqDgHOLGNA\\GRMLkJYBUCOHA`JPDbDTGVI~OLSHOXOPCVWxJ]b@GRB^DNeVCRGPBTGRJRÉ^@KICFMAECCCCE@ADSHeC_MEAEA@EDOHKT[HMCGBYLARiSAE@IKWDEDQTWDE@AAEDQZEBGDEFE^GHC@C@AKIEIGEiII@KCQKG@BCZCLK@GSSIEBEBGGOEEOACAMKGAG@C@eRn_R@DNNLVBFEBSMOCCISBIFCBGd@FHHBH@FGPEHOPWNMXGHKFYFOLSBCQGEMGSMIKEMIFEBGLKJiPGHID_D[HKDWEaKOBQOSMEGCISIGCEGOi[§KaÕ¹ƗEIAKBCRMJMDI@GLODKZgN]PSLIHKKEOASGIEIOKIaWMKiUIIGMKGOCOFKJS@OEWWGKMKIESGYDGLKFO@EOAQBMKKQGUAWCQIEQBOJkI_IM[CUAMLORKHQBU@S@WEcOkGS@QEKKGMAQKGMMEOGo@]BOESeSKOLS@MGOOAQGKIGKMOGQCUBOIQWYg}EKCkUCUDKDOCCUBQFUIgGMKIqSWIaBOJOFSCIDQRGHKBUQWDQRgRSDYFKPIRGZC`BTEPMLcHWJSJM\\EP@REVDNJJJPBXONILIZUHQLQ\\OJSOKQME]GkCILHPIHS`ERBf_FUK_WYCgN[FOJ[dWHECEUUOSEQFIVINiZUDMFYEUH[F_BW@KGQCISYam@QDQHYPINILWPO\\_FaWYBcGMCMBQHKPSHQPBNCTKRQASIcUOYSNQDSOK@__E][BOAmFSAU@SLiBOUEQMQOCQASEIOASGUOEKJSR]TOJWESC_VO@KO@QBUGGOCINiHQCQD[XSDW@WB[@cHFcAiCSKSuW[MMIUGG[AuWAMBMC[MIUCOYEUUSI[FSHONWJOPERPCTAPDJTPFLALBNAPITCLMRcJQRKDO@SDANITAVOH[JU@SHyHm@_AYYScQQODMNOFuWQA[JMbObOL_LOBSHSDUAOBITCl@PANGVSbETDPKJMJ]@SCmcO@OJ[HCLENuF[BUSUIYCWDOFQ@aBKHS\\KHSG{eKJMTMGsqUEckM@UDWNOFILOJcKQAODWXMHQJSLWFO@ODQAISQGMJSXWEQ@QLGT@RDNRVKLQB]D`hDPDZFNGHKLQBGD[POLDJFHTL@D@JDLW@MDILKTCDG@aOIFKLG@OGOKYF]PSFQGIIGeCHMNYDUHcCKCg@LQTMAQHIHKDWIKKYKABDJCLCJGHQNIJCF@XBbHPLNFJBNCLARC´KNWP[ZU`WZKXOdDRJVX`JRFREdBlAfIbMNWNWDQ@UGMKCMUcQMQHSM@]GUAQBOKWAOBMGKAKBMACQG[GOGGGMYKIQMUEUKQE]AO@KBA@K]UPSLCHFJ@FFHJ@LDPNRJJDHADBDDbhFJBLBHFHVRHJGBLILBFLRXXZIF@FN»TAAE@§AëÃFGBCECAABKHILIJKDSDGX[TDJCNW@ECCAETMDG@E@SEO@EBEJGPU@GEGAKC@[CaAMA@C@GDCTONIVGRIRKLAR@TDNAPBjCS^AÀFPEw@IAMGKCCI@EBOEAEDYDK@OCICGMQGCWEGCEQ@CHCXGXAfHDHDF@HZNVVD@DABEFEFiHKBI@MJAID_EEWFIFUdSROD_AIDMhGJOAIMMCIKm]ICEGC@WXUHAKBMK[AGjSRSEU@OMOG[SCQJQJ_PEDK@GAIDGpe@CQB]CSBuXE@KGEMKO@YCIëdaV@ANMLEFGPCFAPeFCN@dCFEDEDAUI_YGAGHIPObSTAH@JCDclALF`CFGBYBAACMQ_@[FKFGJV\\@LWZCNBLT`HV@PANGLMPWFGJBNLNPNct@RExDLNXFFJTg`ILAXETOHUBS\\GRCNIPM@KHGJC^JNGPOnCvFRA\\IfIPGHGRBPCF@HFHN¡ns`SNABIh@TBLLPBR@VGLktE\\DVCVDNBXBTAVEPQHIHWHI^KLM@aKyGS@SJiPOBWCqNUEQ@[LONOROFsDKG{TQBGNBNHZONwFBQBMLMNKTOLUE]@OFWDcPMNWDSLQ@KDMJIJYB[AKDOJGHIR@LMPINCRCfGLMPELQPOL@LHVR\\AF_N¡^WEMAAF@VKL_JKFMNALDLCLH\\AJ]FWHWPQBUGIIKUKOQMIAK@OHOPQ@KDKHKJGlMRUDGF@JFXGVMFWHWDWHYXSNw@UEMICCIBIAOKIAMDELaVGNAJNtJ^RjLLBH@FIRETGT@DHBAJBJELBP@BUPLXfhHPVFLLI^SVKFMLETDNFHLLB\\@VMPATI^DRUJKNQ`URgL[RQ\\GZAXCJ@ThnNbtfV`TbR^`bLHdhJTA\\DL@TTZPdVzPZLXBJKLVVJRLCTAVb\\VtLdLpJVPP\\T\\PFPh\\^^PVEhQfCnLhFzVnVpnL`D¼j|RnR^RĀF`DlBjPn\\\\b`\\\\LFNH\\XLpRrNXCd@XTrV`BHEJSHINKJULIHMJEFKR@FFRNVDRDJJLPLDHCRW\\@FFHDHPNDDBHJLNA^@FHXBLCHCFePEDBHR\\TVJdJTJJ^LZVHXGNYHOBcCM@QHOBI@QEcQoEuJ@FKFIJADBP@RDLAJHLBDCJCD@DDDVDDDBPCbPB^JfBjRtPNF¦xxJFFbTJP`B@FHNH@DCZ@JHHVR~^jHTFcPCJQ^ITyAH@HBLPPDJ@HM AreWAk@GBGFWNSXMlCbBhFFNFJZ^bBFB^`|z`j@RFQfia\\PQLEFOLgXIH@`HjALC\\NbDPC\\GZMVU`GF]PGFEJK^GJQNEHAJATHL@HAH@RCP@XEXBVF^FHJJFFBVTTRPHNFFDF@vAJGN@LEHGFMDODOHKLQbGLGFWRQHWRKFQNaJQAOBgP[DKDYPEBoFEDGJEHCT@NH^BXDH\\X`RNPFDZHLJJLDDRDFBDF@JJb`VJL@DIHGJALDH@DGHENGHAJAbFHRZDH@FGLBBFHHFDNDFLHRRXPZbNLNNDH@JBDHTHLFVZlHTBRBdBFHJ@DCJDLCDGBmAIDADBBNN\\lX\\BF@PHLFLCLBPVXFTLZHLdfHNVZDDDNJPBLE\\@NBHDDHFJDLJHPANMXQhINQPCH@NCJAHDRCHBRHVBLDHBHBHAJIRANCFQTUNEH@BPH\\PPDXDZBPFFBHJ@FAHKT@H@DHDJDNA^FZGN@FBFFED]RCHMjGJMVEZIbBVDHBDCXFNBNFN\\bNHHBX@RDDBANABIBQ@MDMHADBDVFJF@FCHElCDGF@DFDBFBBTNJRPDDBBHBPLXAFABY@GBUHEHCL@DDJAFEH@NEFEBIHQXSLCFCJCHCJEDKDUB[AGBEFALBNCHMLED"]],"encodeOffsets":[[[88191,31711],[88262,36608]]]},"properties":{"cp":[92.060214,31.476004],"name":"那曲地区","childNum":2}},{"id":"542500","geometry":{"type":"Polygon","coordinates":["@@BC@ECKBKAEHGTKDIFE`CNIBAGIKIDGBOJE^MFELEHMJCNGfITFFCHGBGBETEPKDIAMBKFEHAhBJANEDADIDGDIDETKRWJGFAFE@MFGBECI@AHSFCTGJAVBBABEKWAOAGCAOCIQSMAAAEEC@CHEDCFkDG@EIEUEACBCNGNCR@JABABMCAQCW@GAMG[aEMAMEMDWACCGAUJaFYNUHINiDG^QFCEEEAM@YH]EMBICGC@C@GLSBG@EGIEAOEYAWCOC[OOG@AFGVMRSDEBMJQBIAGAGCGAKGUAQDGCQBGDI@MDGROJMRgNWBMGOKIICGECCAG@MF[AKIOCMCCUYGMceGKKYESUWAODKEKGK@OAEW[[kMMAABCJCnBHADCCKDI@CGIAEAcAQGSYkEUGKGSAC@ICGMMMKYaWOQQKGCECMGEEGAAHK@ECGQYEGBaBIHGFMHG@CCGBKHIJG@CIK_UIa@ICEEAQCCCIKKIYGECMO_Q[WEK@SGa@OFQLMFCpEFAZOLC\\ChOPARBbIRMLEXQRGXQHEHKRaLKPGPCNCHEFG@KHMBI@uCEEEGMQOSSAUEEIIEGE]AUFW@WDO@QBG@GGKBSBIFGRMHIL]FIHE^OHEV_NUHYD[COMaD[BKGi@_JGhWPKFERKOb[jReE@Q_i{y]_AAE]aIYMEEEAgDaNkTWXMHEHAl@XBfBqN@GCIOOAK@GBGzJSR]DIdOSEiG}]UQGG@IDY@CMGEG@_AIOaSEEwI¥wMEsOiQeA]IOADaAOCCUCCC@CDCDIACGKBICK@QAOBCJILE@EvIpFdRRFJ@PARGN@dDPAZGHMGWYU]KIIISIcSUQ[AGFCfODEDGAKGW@E]MBIKAGCCOMCGEG@EX[DQCGOKIKCICQMUEQ@ELQFENIJGVKLIJMTGFIAGU_qWSc@WDqMoQWKG[EM[K_[[am[iOkA_CÿE]QmQ{Q»i_CmKomUyUgEmKeDgRUF]O[]OgOES[O[UOoIcKsK[UaBUDSQKUIKULAIKWOYUyOcSY@SCKB[IScgKG_aQ]SaU_seMagm@SDIBWHYR[\\QhKVQR_LMVICQJ]BSNO@UA[KKEGCMFSNKLETUJ]KKUEGOegKWVO@AAOFKAIBIGA@CHSFSJQ@EAGKKQiI]MsBIHMbUFKNCJBPLJBJADDNJVFx@TMZWXGXCXGNEHUEW@IHEVCNQHkLILGLCR@POPGL@JBRNLPLVJJVHRAXOXG^EBIG[DKCKBKNMLE`ILK@UBENBXF¢]`MBEQ[GU@KPKROFKNOHKDeDQJMNO@KJQHGPILC\\BZAJINILCR@TKXCNMdOXCPE^@VFPKLSNMNKRAAxEPMGYAMHMRA|SLHtCPEPQPM\\KR@VFrMXDPAjOTIT@zHbLN@LKJ]XGJGRGFOBUASAWCMDUCUF[lsHK@UAQKOAK@SF]FK_M±}O~UAZCJCPEDMBOHODEAOQIBICIDQNY@IAeFKD_@IHS@EDGFABIEC@GDC@OGC@EFIBAD[@C@MKECWFSEGCG@GEIBODGBCIEGCK@KDGEKGAUDG@CKCEIDE@MEWIEGQC[YEYIaGk@WFaJWN[LMRORSX_TaPcDM@UE_EQ[{amDGNUNQTQZ]XEHIS]KMHMDMLCFMHwAKAMICC@I@CGGCGKOGEEI@EFEDI@OFAL@PDZOBC@IFCDC\\CBBFJHBBIDCFAP@LMJEN@PFXBJAJED@THDB\\MF@LJBCJUIMBCFEFEBWLo^CCBOGSBKGMCODKCIE_AODUAWBIDKHKRMHOHALDNGFG@CEODCNCHE@QCICA_J]LOBCDEHOJCJGDEJC@AA@ADIGCGCAE@QDU@OQOGKYAKEIaIOSKYMyBQB@UB@ACFEFAJAPELIXMROHAPBDCrÍBKDGPSIKAC@Q@EEIIIKAC@GHMBMJO@MBCDCXABSNAF@HGDKAGCAEBMCW@OFIBOCO@OCO@CFIDOB@HAXDBKDCJCFIKMMC@EFE@CGGG@DOAIGOQGSCUAkDmISKUGOKAKYOAE^UT_LUBS@]@MgKeCWDa@WBiOiKcABIaKDKMOFgbKXQjQLALSBCQUAE@MACEAO@]LS@EAKEII@FMTEDAF@DDFADIFAZSHEFILE@IKC@ODMACCG@EDMAK@[fIRINQHOUOEIUKOIQUWE_DMCK@MDKTQL_AOESaQMCWASEMBS[KM_OMEQDMLQT_TkLSAOEKEU@KCOIiKSAQJIRBTCLQLcPUFSRUdKJM@ME[JULKHERIJSJON]T_ZSHSL_dODORGTONajEVWV]BSHWZOF@TN^ERKFqGcAM@OBKNCLKHO@YOMDKH_NFRARMLHRNJFTGRAPGRDX@TCVEJDPOZTPFNFb@VUdONMH_X@TFPDPAJDPCDIDWHI@EBQCKDEAMAG@GJIRKNADWVKP@NCHIRJL@DSPCFOPAHDFFH@HADODCHEHCF@VCJANMRIDQBM@MGGAOD]POFUEYBCCEEQESBCDCFBFDDJDFFADEDgfAFBLGR@NHPVJNTJFXVABCDWLABAD@JEH@DBDNJJDDFL@VHBDBPKD@FVFHFIFCDCNEDMFOBQLGFI@ABB^DDDB`@DBGLWH@B@FNFPBJFF@bJJJCJ@BJD@FDVBZATBRJRJLXLJNNPHNKP@DRDHFDNHFPD^RBHE^FFHFFNTLjTRFLLANHPXVPLNRJBJJXRzTBFADABGJCNALDJRAFCD@BRNBJAFMNGFEFUDUJi`CBCJOJGHC@G@IICAIBIHAD@TRDDFLd@BAFAJDLAJCFKHYVEJKBAB@NADUSTQHAJDRFJ\\`EDOLMDAVPfJni`GR@jDDLXIH@HBLIBCDBDRFBH@LEFEBIXGDNkTIBKHEBAFKAABDDEDEBI@ABEPADHL@DBFGF³QEDC@G@UMKA[BMDkFWCMBGAKHGBAJIHCFMFCDEDIHGBABGDGBK@IAC@CDKDGJEBECGAGDEFI@KFSEG@CFO@MDUL@BBDGDLXILAHDXBHDTDXLXDBBR^DN¨L@NDBZBXNDLLNAJDLNHHB\\@NKD@TNDHBDH@JC\\@FAd@XSvOlPHHBLTVHFZN@TFLCFGF@DHVJNT\\XTrbANCLCF@BHFJ@FBBPJDBD@FGF@FHF^AFBJHHBN@VGB@DDBJUHKNeTONMCI@gRQDQ@IAe@MBELSHk@iDW@YFOJGH@ZNHBPIPYZEPAHDFBHAHCBKHMDOLELIBEFOFMHS@IDGAIEKMGCY[BICUBKDIJO@CAE@GBAJF@AJQBIDKAGHI@KNIPOFMDKHIBEI]BOGKAIBEFGTMBCAESGE@EDSZGRYFE@IAGDMCUUCOAKCGOAODMECBABAFCjCH@JIZEJEBG@EEUAEBCDGBCAIAKEG@EBCLA@MDM@ILE@EAMIQGUAMFMBGDKEGK@GA@KE@AFQBQDIACGAGIGEcCIBAEACEAOICBEJEDIAWFIH@HA@E@UBAB@DJFYTO@U@W]MKOEQCMKIQWSUA_FM@MC]OMAc@mJgDKAGCQMIKMGMDMLGJGBo[WGECM@]HEDGLQL_REBU@MBWOgKSKGAG@[TUJgDmAGgJYDSJKBKCGIGAYBiH]ROBW@OBCDOZOJODEDALKZIBN\\BRWLi`[NEHG^KZA@eEEEAACEEBEAAIBACNOLeEeA@C@KCO@iGSDMTEPEHKZMJK@GDMBQCqKKKMGIGKYmSEASLKCKGGAWKKIEIAGPQFEEKQ@EFKFMBYACDFHLHFLMFWRGBGC_ECDUNIFG@QEMAECGASAgOAIVBHCMS@IHCJDJJJFLHH@FEAO@]TS^IVGBGOIEAKBcNM@KE_CoGIF]LK@MCE@MF_^AG@ICKKEKAGFGBAGDIDQDKDIHIBGFMFANCJ@VFDDLGNKRYXQREhGtMd]DE@KOOKYG[EuBKRmLKFKJkPSDWINwRMKG]KAE@GIS@CDALAFADGAGKGSUEIDKLKDEDSCEE@GDGDCFIDG@EGKAOFI@CAIMWSSG_FQBICKD[AsO@ICOCEAGBAKOGYGIAGACCO@MAGKSCYAIBIDKLQ@EBOAMJKHGbWJMFIFKVKXUJYHOVULGFINMF@PR`PRHVBLKHMDGBWHKFKbGHELKAUEKLINGVATGHOA[V[^QTA\\BVHZDdUZCTB`@JILUJ{CYBqVUJCDIAUGMIOCMIWCYCKISMUCO@KQCMGACGCCK@IAIDIWIAOGMQKGKGW_kIOMCSDWRQ@KHKLGdKNKBUA[ISGKAOAOBGHO\\K`GPCTF^ERLRVNNHJH@NIHJaJKHCFWVERKJaDWA]DIFEHAbBLALENGJ@FEHJN@HKRcVU^EFYIIGI@OKOCUL@DBJABIBWJCCEKAGBCJG@AGGC@KKIEEBMGUAAA@ENIBAEAOEIAKB]ICC@KGOEEDERA@GDGJEBGGM@GDKFGDIEQBEDIAGCCOE@CE@GSCSFQNEV[BEACQUCOKEMIEK@CFG@QACQOKWIICE@EJMBI^wAY@AFEJQPMP[\\eGS@SGAUBKECCAAK@DMHCBCHEBIM@EC@CBK@CAAUCODEAECCGEEOBICQBADKBABGVCFSHIPUHILEFOFkJMFQDG@KEEB@FBH@FKDIJIDCA@I@AHCDEAIBC@U@CHA@AGQKIEAIKG@CDKDIJKDI@@EEGEUDQACA@AHSF@NAJCFED@HJHDHIH@BH\\I@ICUKSCoFCB@JELKPGDGBU@EPGDC@@ABECEmyEAE@KFG@CDM@BKFE@CDCAIBEFGHC@AAGIICOECGACEBKFUCEAGGE@MBCHEBEKIEKIGEGCEGOMGMKIEMAIOCAEGYOIGQKaYEKWSISEAMDCHC^GFS@SJGFENBLPPFLAZ@TFTJRLNKNWrSVYFQHGAIIOQOMG@SLEBQGOLGAQYSIKAMDodCRMNI@[WIBmPmHQTQLcBUAMBcPODQBYAiBUBQFMFIHCHENEDO@y\\YF`WNKCCEJ]COKGMEdQAGQDYIKCQBQBSGIyFcN_Dsf]ZoJQFG@MKIUFMLKTKPKEIIIe@GQDUHQ@IQY@GpMJE@I]SMGCCBERIJI@MKOOOQ[@UDgAGGMkQUWUAMU@ICOL@HABCDE@@@BEACU@uCKGAEBItiFODU@OG]MgIOIMSOICSAAEFGLGFKEMMCQE]CWNIJKB_QB_FQFyzMJAH^@JGTa@G@B\\ARAjERMHMBQbSPAHITIJALNJITSPHheXEBaNQFWBGU@EBAHHNCHSBGREPIFSA]CG@OJKJOHaBQAePifWdIHk`_hYXULKBQCMBKDIPUTUPYLgV[F[HO@[CUESIIGSEGBKJ_bgXaHiFcHEDaj_HOA]B_LUAOGMFSRgYJeBSCeAeRiLQHiM_EQAsaOCWDkVYRK^]DWF]LGXCVITMNINMZa\\wVGHIXX@AbKVURDPLVC^UVQNmPUBODIJALLLRDJFBLELmnMHOAgKiAQDKJYhkx[^CJYZSJMAYBSHQN[\\KHgVEACM@MKSOEqIWIQMCUIGEHCREJULcJQHIFQjSRONeCDSAYDEiQE@AFBVE|ELOFC@MDMGIISYSMIMGCMEmK[IIEEMFOLKFMAUNMBGEMMEGAMBMFSB[GQK_GgAU@MLGLAN@VKTGZILSLQFWEMK[EcBGCOMgCGCCDENo^IPIJsVMBaJGHGVGLGR@VGVSNGLEPDLN^X`FNEXUNkTKPI^IJ_LOvMLUH_\\KNGnW\\G@AEIW@QKEUDiLGJUHWCQNMRUv[ZCPN|`p`hBHaXWjQLs@GHCJ@XDR^tXHTLTBPDRRnXPJPLXBLGZCfCFyMM@OTUyªS^ORAFNnHP\\TpZXJZD\\HBFBPFNrpDRELKL[FQHCF@FABBJKDIHQHCDCJQNUFOBE@SHKBCDK@IFEFQJKBSJIBIA@FE@G@EHEBIBECC@BB@FDDEN@HF@DJDD@DH@DJ@BGNMHG@GCUNQPCHANCJEDSNMDSJC@EFGFAFMLAJCDAF@FDDEBCD@FEFGAOAAEIGKACCGCM@IKUL@DCHDLQDEJHHBB@DGP@JIJHL@FCLWDEDBdBBRDJHHLHF^JPHFHNTH^@NBFPXJJJLFVMRQLWDEH@BHJDP@NGPc`KPFNPVBXBHAFDP@VGNSTKPATUV_nONaTEFER@JPNJLDLRPJHrHRHLDT@TCbNRTT`TDTBNCHJRJRCX@HF@`HHF@~ORBHFJLVRTLfJVlZ@ZLLTLJTHD@NAFUFO@OImLUTOZ[V]@WGM]cEOJgJSXAMD]NMLMR_L_LKLEPEb]nCHCLMVMTCHGBWJKi\\URIH@BNDJ^l^TXBV@tJ\\@rUVAFJAfJV^Z@REbBP\\nRJ`VhJLLFJDPLBjID@HJBHFFJ@\\KLHHHJLBHJFTT@RGRPVLLXfVBBDARO^A^]\\O^GZFLRHHHGZFRTFHHBDANKPWjGNI^UPQBaGECKFI@BDBH@DCDDJ@FCJFBFHBFCFFBBFMJ@FFFBFBJFBFJEBEHCF@LHPAFFDBLGLGB@FCDNPBPCD@DHJ`rFD@DKJEBCDGDADKBEDEPC@@CEEIAA@IHG@GB@D@FAD@HADCDIDGFE@KGGBCHDHAFIFCHAPAFMFiøC`@NLhRZHHFLALENSP]TYAWJg`SHMP@NDHRNAFQBKH[JKFMNC\\CjBFAH_^I@KDkCWFSPKREPE\\MXSHWNOPi\\GHiD[D]JKHEJARahGT@ZOJOL{x}EPBddBHEBmEQ@UDedS^@ZNRô´BFENSbQrANPB`EhIPEXDLJJFJ@PALEFyRABJpBNBJJv@HEPINw\\GHGDYDGAUDIFYLGJ@^RRHNCHIJFXLHPATOHBJJRFZAl@\\FRNHHd`PRJJRJLAVMTGJ@JHFTJDJ@LBJTBHHLJDNAJMHGfQH@NFLJHJFrLXHVDTdfF^HZLV@JJXDVCL@VLLD@KRBNDVPAFGHCHJTJHABMJADMLCNIDEDDDBDEJAJEFAFGFGJADTHRJN@@H@FDFVHJFZADCAEFGBGFAJABDVRXJVDVL~PPCJMNINMRCLBNI`CZAXDRFPHVTJHRDJPCJ@XKXMT@bHrTlL¤JVDT@TMPFPLN`RHVMFMXKV@pLl[hCfDVD^\\T\\TFRIdIVFV@~D\\FXTNHLJTXLHNJJJPJBPa`CL\\lDVFPThHJN@JL@RANg^GPHLbFNLbHIfBLATANCNHNDLJHFB@LNPBNDDJB@JAFDBBD@HHJFJNJ@DCD@JDJFDDFCDMFCFO\\ALCBDHHDF@BFCD^AZHfGP@LEFBFHCV@LDPFLBH^N\\@JBCHFJG\\HBDH@FFJALWHCDAF@RETHFDJZBBDCLQFGN@DDHFDHABDJbSRCFAHTJDDV`NF\\XDBF@ZKXGP@HAH@ä°VDDDHRHJLFHLBBJADB@DBFGJGDKD@FBHELBFtPHJDHBNFF`CP@DBBLD@XAjML@FDhDNAJEJNABgTEFODCbSPMTQHMJGJSPUXKH@BHDFDDXFJAXJL@PFTHLPNHJFLAH@BRJRFfAdBX@PDLLLVTNNTVF@DGJ@DJDBB@FDDZPPCDABACKCYBGHKnGpOH@PBBCAQDAREH@LFHFHJDDD@RCNENCFGJCFAJFNBXVRHVA`WHGvBHKBUFKfKPAHKGQCU~G@TAZDVD^DJ^GXSZIVEZ@dNXGVWLEVAjB@LCJDQNMPKB@DCJ`@\\HBF@LFFBFAFCDJDDH@DGBOHDBBRnnbGVFdLBEHe^CVIFMTO^ExLPCHKJQDQJWPUHA\\PPDRCLCVCD`NHVFNCT@TGDCD@FDPAFB@NFFDBF@HCBADEFAJBPRHDBAFE@AJGTCDGBIF@NFVFJGNCJ@JDH@JEJADADEFI@MFGLG\\KFEJMLCV@PSDG@EAQEMAMDITUDEDAF@JFV@DBJFJ@J@FAHGXBZC~BdC@VDZJrZ\\RXBv@\\LPBPB^ESTBRHDDNBPHVFf@TCFBNNL\\FHFDBFJL`JJ@HILAJALHF@FAPBFBHPDBVFHHLDHFBDGD@BBBJDDD@FAD@DLDBLALCBCNBNIJAH@HHD@DEF@HCBG@EHAFBDGHBFGV@FBHNTIPVDNCTDH@BCL@PLRVbLZBxVTRLDL@bOHDFXBXJJXFhEPDXPRRJPHHRDxKVFTLPLNNBLI\\JT^`AVGHGPGTARZHtCP@VDLPLXBXFZNPTJtLN@VA_XGXBjTXEnQ¢IdOLUTG[VMNOXETHpbbPPfRH`IR@d@JBRAjJNALGBMPE@bARCNGCQIKEQAONSNMR[FKBaCwGIIEBQTYVyDOHKRKRE^@VCVK^KPQJMFSLWNKbYPGLGZEZ@bGTE^F\\FVLTNPRPFRCPKlUGlBXETCXKNCTBRCJEhABHCFKFAPANFFAHKFIFC^@JDHDPBFFH@HGVABCBCAECACWHEZFbD`HZBRCLUREjLTJr^PDB¶ANCJKP@dHpD\\@HDXBLDJD@LFH@NDDZXBHVLRFPGVBJDBD@FB@VCXA^LhJHEDEBEDARDJCDEB@VFLHD@DALGJAHIJCJGHOLKHKH]DEBALBdXHBR@LHHCNKNIDCDIBAVARFFDJJJLDDJLDBZHPBJFFHFBFBHCHBBBHHPJdALDR@BBjJP@bFJHJLhVrTNHPPZLPHTFfHBFALLNLRATBDFDJBDBDF@DEPCBiHEFADBLCJDFBBdJRBNFFD`H\\@TBHFBF\\HLHlRZBN@NBPALDRD^H`NpJHFJ@PFNBNBTEJAXBPD\\NXDXTNDPFTPDBXCRJZFDBLVLDXBDDDHBBlNRDTLbNZBFDFBdF^HDDTXX`NHLD¢TMJ@L@ZGJ@VDTCLBZFbPnJTHNDNDHFDFADGJ@BB@J@f@lRF@ZADC@CGG@GRERIdEfSLCTORUJGDEFmDGDAH@HBXBPCLEPAJEH@dIjAJCLAHCXAjDVGDG@OHGHGLEF@VGJKJAPMFAF@HDFFLDPCJBNLLBH@@LJHBVJHHBBDALBXPJLRFTHDBB@JBDFDdHFDFDFLXLX@ND^BPHPNL@NFLBTBXCHBPFLHBBFBPBLALEZEjNLA\\DP@jJL@fERBHADEL@PNPBDBDDDJHJPFDDJTLFJBBBVV@DDDVFHDFFBFDBJDL@RGJBDDJRJL"],"encodeOffsets":[[88137,36722]]},"properties":{"cp":[80.105498,32.503187],"name":"阿里地区","childNum":1}},{"id":"542600","geometry":{"type":"Polygon","coordinates":["@@RLNPVBdCLLVfXJZDNFNLP`PPZ@XNNLZ\\VLZ@\\ENGLDXIBOA_AMDOPKZA`@vARDHPCPDXVFVBX]HKXKX@hNNADI^@\\CTENFnFBBM`BLENCF@FVDL^RFVDlEVF`VPJVDR@NE\\[VEVAXCTI\\IVDTHJFLJPJND\\DPETObGjEPGHQLMPAZAZFXJLLN@NINCLKFMLCRMVFJP\\LNDMVFFRgtBLHHCTFTVbPNTF\\FXKVKXQRQZMJMfQRBLJ@dJLRAXFVJPDZOLKXATGRQfIRAEIKIYWAOFMRMdQFKHMTINHNNFPEPBLXDPGfKTDDNEdBRfDIPGRKPONERFTLXJN@LG^[`GTEHKTATB|M\\IhAdCRINQHUQmQSEcLIfENEHMXMTAHKDMFQ@QNONELaPQXGT]LGPKKfUDKGG[IQMASHMPMPKVInONKAOBMPSTI\\@VDP@vYLFTBPHPPVLVDRCPOHSJGPBVXNAJMBiHQPU\\EV@LNFRPDRDvIVHXTBV@RHTJzLPRFPAP@NFRJLJRF\\@PFLHZHVFTATChIJCPFDDP@LCPFJHNBFFTGN@DCLEDCBEECOCECJCLKHMHWTSLEFAFBDBBBBJT@DDFHFDTCHGF@DBDFBXVZFABCHCLCR@HA@KPSNEHGNILC@GCAEAAIPCRORGFAACEE@E^ALDDADGBI@CEEEMAORw@ECC@IBA@CGGCGAA_QSAEE@ADAHAHCJ`GVWC]cmWi@QLO@OI_KSW]SSWMsUIUBQVeBYGOUQaMQWMUB]MWSYA[KMeIUUK]@WT]@OAUFQNK^WXMXANBVAVKPUH]BWLY\\EJ@LA\\SNIHKH]BIRwJMN[BSOQASGKKIIaIGSAY@ECFEHMPMHAZEVIDITMZ[LKZINDF@BA@AEK@CNMJQ@SGQ]QKAG@KBWJ[JMLC@GEEAMBOMMOI@QDQ@E@CAKSIG]KIGCEOI@CHKjWJA`WN@RDLCBEAG@OBKB@RA^WNIDE^IRIFIPeLs`mBC\\iDIJGTI|PF@NET@RFNNR@TKTEfCjaPC^DDA@EKQAM@MHKPEVCP@PHBREfB^A^F\\DHf^F@ZSNILARDPJDHALF`BfATKPCLFJJNFPF^A\\EFUBIBSTGDGH@HCd@FTPJNHBZBJHHVQGPERATLjDFNJJDlFJAbQ^GHBLRBHEFMHENDPXpJHF@HPDKJEHEIaFaDEJK´¥HErC^BBBBJR@BLFDDFPAJBFABEFCJMHCLBJFFFFBXBRENBJCZC@AEECEKAMGAEBETMt[rPQVQOAOIMCEQBEFCNCBEEKKKCE@CBAVQVKBAA[DEFAJAlHJ@FAAiD[AS@QHSJiHKNQDGCUG[K]EUAC@MCSBMFU@MFMFaH@JDXDxJ\\HVBJ@FBDJHF\\@TRLCNBF@PED@HN@FIPAHKLQDMFCH@HFPBRBBNF@JCHABDDDLDDBLJJVHNFD@\\ONKHAB@BJVRZRDFHFCFMBQNUVONCFAJCDEDWDKFGH@BDH@DAJEFAJ@H@BPBLFZAJGVCPFHHVJTKVQ\\KX@\\HHENMVS\\DPOJKZ@ZSDOHU\\WTGXYJc\\WJAXQCYJSbcbInHhBARP@^HRPLLAtKFMTcRQRKPIPENIBGCG@MCIFGBEDWAWDEHABCFCX@\\HHFB@TKBA@CAAbWJIFAFE@CGGQEIGAGBCFC@CKSC@KLA@AA@ILShmTeHSJKHCTCDCDKAgCIDKHDVJLB\\EbCLAJPHbDHFFZXHFBD@DAFFFHBDCFIdejOLENORKF]EKBOFGFAJS@WBSXaF@RD`GRSHIBKF@VDVBhJVJRLHFJ@VYHSLUFKLEP[G[COKKGKLKJQFSEW@IDQReLIHUFIJGBGCKDEJIXGNGFEJUHCFOXSBCAEACMIKOCQDQRSXQLCbHN@JAPIcbMHIFIRYBE@KCGCG@ARAJCBSTMHGDGAIHQJINKFEMaKEWEICIEGIEUCK@ELQ@ACGIWFQAGDQCKBG[GCCBICE]OaBCACEIEKASUCGGEAEAACSGGGBMB@BE@WLCAEDCDQHABG@QEIBOFYISCUKCAAKQQEOGEKEIACBEDQPEAEDC@G@EAG@AAACKECEBCHI@GYSUGCCCGEG@E[BIBUCKFINNX@DOTDZANCFFH@DADGHELABMBGHF\\HTBPANBNAHCDKDAFFBHHDB@HKHCJALIJGLITBNMFQBGHQ^MBCHALFFFPAJ@HAFKFCFCBCDGDCBAHENAHFNAHADQNGAIDECGQEECAQCKAMBGCIIKAEOCQ@KA@CBURMDCCCGAIAQBGFIFElYJKH]@OHE@MHGJEBIFEAKLCHKBGAGGCKA[GQMKAU[GAKD@FADCBE@SGU@IEKKACBeAOJKBIAGGEC@GDC@CAEKGAGB@CCIQMMNCHWPkLELA`EPIFUHc@MICQ]CWPQPGNAHDVLXHX@LMZOLQPIPSFkJMJ@FTTOPQFKJILOL]jKFCKCaWCGCS@IEE[BWJSGKCIBEJGZGPWbGJMFW@GDEFCNINBNHNKPAP@LFVEJALDN@N]nKPOF[DEPCNGH_DMRQDIAMBOAMMUSKAOBIDCH@PS\\UBMCY[[OGQWQKMOAK@AMAaDMZg@GAGMIYEAIPW@MKWGAIICAKACC@EHcNEDGEKGG@CPEbQJKCKGKMEE@I@CDYCMMKC@GFOHMJEBEAAOCKKIEE@WPQPUPILC@KIIKQIAEBSZ_AKKAKIIEGAI@OEK@EJUCGBC@ICCC@GBEEE@MAIDGAGFAL@JCDECQEM@GGODEHI@CMM@KMCI@EECIKBEEAIBC`WDE@EIQy_EGE[FMHKHELCNARFhDdJF@AIGOAKL[FAPANBBGDCRGJM@EGMcSIYMUCMAKBWEQAK@EHE\\M@CeQ@CZcBG@AMKWGIAKBULM@SAGBCB@DBPANKNCDILCBCBOAcWMQO[[g]ekCAUGGIEQUKGA]GCCCOIGOCaGGCGI@EDeAMCKACEAG@KFODIDG@GCERADARKRCJAH@HBHFPDL@BIPAD@DICCDU@ADA@ICBACCACQEEBEB@DCD@FCDBJGBEPEBADEDAHCF@DEF@DGF@DONIDK@EDOBGFC@CBADGDCFCBECEBILEEGHGAKDCA@CQBIAEGKGE@CDE@aEGFAAK@CFKHAFIHGAGFKBQAE@CHGFCLQTCN@NCFEBQDSAIJOBMNCBWBSFMJMHEAKGSGOBGBONMHIHQTIROHADGJCNO`ERURMHGBS@IDOPKRCDIBUAIFOACDADBFCF@FIAIBGCG@C@CHCBI@CACCCGECCCYxB\\ELCFOLIXGLKLQNeNGDIAMKQGGAO@ACAEJSDKCQCCMBmAQFWLgDQFWJUHCFEJG^BNIRCNAHJhANCFINEDKBsB_CWGSKMEOCg@CAGGEASF[@]@QF_@IC[MGGAGCAMIK@WD_CSB[COLIDWB_Tml]V]EKAOJGVCbCRshYKQAiJSEWMo_I@[J{@OC]OgIOA_Is[WM¥scO]cIçgga]QcGc]©QS_[MSWQa]ecWQIcMaIsUaMWEu[[q[iScIMYKueeOSGoeeKOgOmW[Sµ_[K_QOIs]Õy[YOSG[ANQESK_OYAaD]FYIaGcC]D[JASESQ]cEPSFKFINA`OPIH@FDL`j\\RRJRJjdXNTRNFLLNN^RVHVDDF@JGFIBCDKDCAOMA@E@YTOHEH@PFVBRLR@JHLLJBJAFBDFDL@DB@FGHADPLHLDHADGFUHKLMDILAJFFBDARBPFP@NELIF@NGTGHA\\GTEHKHCRAD]VOHEHGDC@IAgAMHKJEDSBIFEJCXCHCP@LELGJKFGHCH@NMNCBG@CBAJ@FMFEJI@CFAJHJBLBBLFHHBJ@FEHAFCTDHCFAHBD@HBDDDFBBDILDF@DKLAHCD@DJ@FDBBBLBPEJDHBHAPCF@FBFADCDMFOBGDC@ECE@EBGD@JCFIFKTOREDENCDCHKPIJEJADBJAFBJODAFBD@BKBaBQAACIAKFYDGAS@GCOHIACAA@GDKBEDM@GBEBAFCBK@CHGFONIPAJEPATBD@JDL@DAFIJKRDNERLNPJDFEJKLBL@FGNBDFFBBAJDNLPCD@HEHBBHH@DADIHGH@HFHYFGFCFIFI@CBEJKJMT@HEPBTAFEDGB_@KFCFALGL@DHL@FADG@_KMNI`QVMLqc[M_DIaQUDGfULYBWEeMgFCAWCICQDIAYIE@YFgFOEEBAHBFHFFFABIhoRH]IcA[NMRKXK\\oJ_I±CUgY{JcAwBI«PSBKDS@GFGDGBMCaOGRGHCHQTDJBDABGFG@IMC@ULWFKIYEIIGCG@II@OSU@WEG@IESM@GBMIIBIBOCKHOEQFK@CBAXCLMHGHYdYD]DYAgVSCsLWCQHEEGKCASP@FECAHKBOLSD]N[HCD@FKFKHMHQDKCGGGIGEOUA]CGBKAAKKDIOI@GIG@GCKAAKGQECBAPABEACBSJEDGJKJ_VSXIbBL@JMX@BfpBLBFHHJDJ@JFHJ@JJFNLB@J@F@LJPAFABEAKLOLENFDE@GFCJ@PTHHB@D@BMBAPCAKDIFATALCH@DCL@HCLBDDVFJDN@FCHILCFCL@NGTHV`DZ@TJ^NXRX\\VZNTCbBZZPRJ^SdFbRXDZHZLZBRFT@RPPrVf^NPJPVN\\Fj@bFLPDNNLNHHNFTBPJX`ZVPRRVLPFHHLRF`VnBRADILARBJBBPBHFJJDXFDZE\\DV@XHLHLXNJDPk^ApB\\CR[NIRHhAPBNLLTLFLMNEVEjIRUHKJAPINUBUHULMNMPUTWdLjHNBLIPIR[XcPQJONGNMJyHQLSJKCU]CKUG[JMIIKE]YBgHSCQEWYMKMEUAWBUBQJ@PANMLERMHQFWBUEWKOIOQKQKG[NSBO@SE]UKSMWMQIOMQAODSCQSIMI@eKEXEPARIPARV\\DRCdDTHPCPVPRZPNVbLLDPKHWXIXDtDZC\\KJSAaKKGK@KLC@IACDAHBJ[AKAMDG@GACBA@CZKNDQFY@QEG[AMOO_SO@KHITATIRELKLEN]ZUTkLU@oNWDUNARNNBPKTDPNJDXARLHRAVMjOrBRFRPTHbX^ZfXVDZIPQR@FLBNNNVJXBLPNHXDX@LNFRUJQBIJAPLNPDNH@LBJdTjXTH`INMVBRJPDT@PFFL@VF^HLRDLCHVEJDPDLNHjXALFLLDNRGZIJNN@dCZBRFLBVITCTPL\\AjYZCTLP@NGTBJTEVOLMNHNTBVITC\\INHARInJLHZNPFPLPVBP\\CLRfERIPa\\KDAN@PNHTjHPRRfDlTRD^ER@HMNBNRBPFTDTAxFJNLND^AbWlKRMTIRRHLN@NETAZILSCKIMAMDMEcBUFQXQbIbC\\IVSFMAQCIPMTIHW^qRKTCf`NPTRVHJJRFPHFRNLPFRHFNB\\ZN^IXOXS\\S\\@TDrAXQRSTQ\\UXMRKLWAUGQKGWEEMBYF[TQTGVQbMVEdC^IdORDX@REVUVEVBVGrBPDLHBJJJTHR@JOFOXINDrF\\Jd@RMVK`ERHLLDP\\NVFXE`IXBHLJN@TFRhDnMPO¤eTBX@ZER@LFPLEjDTHRLTDZNBRERB\\X^BV@TFRNFVBpEZITETNNpPRJXJ"],"encodeOffsets":[[96414,31219]]},"properties":{"cp":[94.362348,29.654693],"name":"林芝市","childNum":1}}],"UTF8Encoding":true});
}));